<?php
declare(strict_types=1);

namespace Tanzsport\ContaoFormationenBundle\Controller\Api;

use Tanzsport\LigaTurnierModel;

trait LoadTurniereTrait
{
    public function loadTurniere(string $liga): array {
        $items = [];
        $turniere = LigaTurnierModel::findPublishedByLigaOrderByDatum($liga);
        if ($turniere) {
            foreach ($turniere as $mannschaft) {
                $items[] = $mannschaft->asArray();
            }
        }
        return $items;
    }
}
