<?php
declare(strict_types=1);

namespace Tanzsport\ContaoFormationenBundle\Controller\Api;

use Tanzsport\FreiesturnierMannschaftModel;
use Tanzsport\LigaMannschaftModel;

trait LoadMannschaftenTrait
{
    public function loadMannschaften(string $liga): array
    {
        $items = [];
        $mannschaften = LigaMannschaftModel::findPublishedByLigaOrderByStartnr($liga);
        if ($mannschaften) {
            foreach ($mannschaften as $mannschaft) {
                $items[] = $mannschaft->asArray();
            }
        } else {
            $mannschaften = FreiesturnierMannschaftModel::findPublishedByTurnierOrderByStartnr($liga);
            if ($mannschaften) {
                foreach ($mannschaften as $mannschaft) {
                    $items[] = $mannschaft->asArray();
                }
            }
        }
        return $items;
    }
}
