import { svelte } from "@sveltejs/vite-plugin-svelte";
import cssInjectedByJsPlugin from "vite-plugin-css-injected-by-js";
export const viteBaseConfig = {
  plugins: [
    cssInjectedByJsPlugin(),
    svelte({
      emitCss: false,
      compilerOptions: {
        css: "injected",
      },
    }),
  ],
  build: {
    outDir: "../src/Resources/public/formationen",
    emptyOutDir: true,
    manifest: false,
    rollupOptions: {
      input: {
        index: "./index.html",
        ligabereiche: "./ligabereiche.html",
      },
      output: {
        entryFileNames: "[name].js",
        chunkFileNames: "[name].js",
      },
    },
  },
  // api proxy
  server: {
    proxy: {
      "/ergebnisse": {
        target: "http://localhost",
      },
    },
  },
};
