export type Ligabereiche = {
  saison: {
    jahr: number;
    bezeichnung: string;
  };
  ligabereiche: [
    {
      bezeichnung: string;
      zuordnung: {
        ltv: string;
      }[];
      rigen: {
        bezeichnung: string;
        leistungsklasse: string;
        id: number;
      }[];
      turniere: {
        bezeichnung: string;
        id: number;
        ort: string;
      }[];
    }
  ];
};

export type Ligatabelle = {
  bezeichnung: string;
  jahr: number;
  teams: Team[];
  turniere: Turnier[];
  turniereSoll: number;
};

export type Team = {
  bezeichnung: string;
  startnummer?: number;
  trainer?: string;
  verein?: string;
  formationsgemeinschaft?: string;
  webseite?: string;
  summe?: number;
  platz?: number;
  platzSkating?: number;
  aufstieg?: Aufstiegstyp;
  zurueckgezogen?: boolean;
};

export type Wertungsrichter = {
  name: string;
  verein?: string;
  ltv?: string;
  kuerzel: string;
  staat?: string;
};

export type Turnier = {
  id: number;
  bezeichnung: string;
  anfahrt?: string;
  vorverkauf_telefon?: string;
  vorverkauf_url?: string;
  info_zuschauer?: string;
  ausrichter?: string;
  adresse: string;
  turniere?: {
    datum: string;
    startzeit: string;
    bezeichnung: string;
  }[];
  datum: string;
  ort: string;
  veranstaltungbezeichnung: string;
  webseite?: string;
  teilnehmer: TurnierTeilnehmer[];
  vorbehalt?: boolean;
  wr?: Wertungsrichter[];
};
export type TurnierTeilnehmer = {
  nr: number;
  runde: Rundentyp;
  platz: number;
  disqualifiziert: boolean;
  teilgenommen: boolean;
  jswertung?: {
    score: number;
    runden: {
      runde: Rundentyp;
      score: number;
    }[];
  };
  platzwertung?: {
    tanz: string;
    wertungen: {
      platz: number;
      wr: string;
      unten: boolean;
    }[];
  }[];
};

export enum Rundentyp {
  VORRUNDE = "1",
  ZWISCHENRUNDE = "2",
  ZWISCHENRUNDE2 = "3",
  A_FINALE = "FA",
  B_FINALE = "FB",
  FINALE = "F",
  NICHT_TEILGENOMMEN = "NA",
  DISQUALIFIZIERT = "DQ",
}

export enum Aufstiegstyp {
  OHNE = 0,
  AUFSTIEG_DIREKT = 1,
  ABSTIEG_DIREKT = 2,
  TEILNEHMER_AUFSTIEGSTURNIER = 3,
  RELEGATION_HOEHER = 4,
  RELEGATION_NIEDRIGER = 5,
}

export const Rundentypen = [
  {
    name: "Finale",
    typ: Rundentyp.FINALE,
  },
  {
    name: "Großes Finale",
    typ: Rundentyp.A_FINALE,
  },
  {
    name: "Kleines Finale",
    typ: Rundentyp.B_FINALE,
  },
  {
    name: "Zwischenrunde",
    typ: Rundentyp.ZWISCHENRUNDE,
  },
  {
    name: "2. Zwischenrunde",
    typ: Rundentyp.ZWISCHENRUNDE2,
  },
  {
    name: "Vorrunde",
    typ: Rundentyp.VORRUNDE,
  },
  {
    name: "Nicht teilgenommen",
    typ: Rundentyp.NICHT_TEILGENOMMEN,
  },
  {
    name: "Disqualifiziert",
    typ: Rundentyp.DISQUALIFIZIERT,
  },
];
