var DatenMeldenApp = angular.module('DatenMeldenApp', []);
DatenMeldenApp.config(function ($interpolateProvider) {
	$interpolateProvider.startSymbol('{!');
	$interpolateProvider.endSymbol('!}');
});

DatenMeldenApp.controller('MannschaftsdatenController', ['$scope', '$http', function ($scope, $http) {
	$scope.liga = null;
	$scope.ligen = [];
	$scope.mannschaft = null;
	$scope.mannschaften = [];
	$scope.absender = {name: null, email: null}
	$scope.routes = {
		ligen: '',
		mannschaften: '',
		melden: '',
	};

	$scope.init = function(ligen, mannschaften, melden) {
		$scope.routes = {
			ligen,
			mannschaften,
			melden
		};
		$http({method: 'GET', url: $scope.routes.ligen}).then(function (response) {
			$scope.ligen = response.data;
		});
	}

	$scope.addTrainer = function () {
		if ($scope.mannschaft != null) {
			$scope.mannschaft.trainer.push({name: null, email: null});
		}
		return false;
	}
	$scope.removeTrainer = function (index) {
		if($scope.mannschaft != null) {
			$scope.mannschaft.trainer.splice(index, 1);
		}
	}
	$scope.addKontakt = function () {
		if ($scope.mannschaft != null) {
			$scope.mannschaft.kontakt.push({name: null, email: null});
		}
		return false;
	}
	$scope.removeKontakt = function (index) {
		if($scope.mannschaft != null) {
			$scope.mannschaft.kontakt.splice(index, 1);
		}
	}

	$scope.submit = function($event) {
		if($scope.form.$valid) {
			$event.currentTarget.disabled = true;
			$event.currentTarget.innerText = 'Daten werden übertragen…';
			$http({
				method: 'POST',
				url: $scope.routes.melden,
				data: {
					liga: $scope.liga,
					mannschaft: $scope.mannschaft,
					absender: $scope.absender
				}
			}).then(
				function (response) {
					swal({
						title: 'Mannschaftsdaten übermittelt',
						text: 'Die gemeldeten Mannschaftsdaten wurden erfolgreich übermittelt und werden nun geprüft.',
						timer: 5000,
						type: 'success',
						showConfirmButton: true
					});
					$scope.mannschaft = null;
					$scope.form.$setPristine();
					$scope.form.$setUntouched();
					$event.currentTarget.disabled = false;
					$event.currentTarget.innerText = 'absenden';
				},
				function (response) {
					swal({
						title: 'Übermittlungsfehler',
						text: 'Die Daten konnten nicht übermittelt werden. Bitte versuchen Sie es erneut.',
						type: 'error',
						showConfirmButton: true
					});
					$event.currentTarget.disabled = false;
					$event.currentTarget.innerText = 'absenden';
				}
			);
		}
	}

	$scope.$watch('liga', function (newValue, oldValue, scope) {
		if (newValue && newValue != oldValue) {
			scope.mannschaft = null;
			scope.mannschaften = [];
			$http({
				method: 'GET',
				url: $scope.routes.mannschaften + '?l=' + $scope.liga.id
			}).then(function (response) {
				scope.mannschaften = response.data;
			});
		}
	});

	$scope.$watch('mannschaft', function (newValue, oldValue, scope) {
		if (newValue && newValue != oldValue) {
			$scope.form.$setPristine();
			$scope.form.$setUntouched();
		}
	});
}]);
