<?php

namespace Tanzsport;

/**
 * Class TurnierMannschaftModel
 * @package Tanzsport
 *
 */
class FreiesturnierMannschaftModel extends \Model
{

    const TABLE = "tl_td_erg_turnier_mannschaft";

    protected static $strTable = self::TABLE;

    private $_kontakteAsArray;
    private $_trainerAsArray;

    public static function findByTurnier($intTurnierId)
    {
        if (!$intTurnierId) {
            throw new \InvalidArgumentException("Turnier-ID erforderlich!");
        }
        return static::findBy('pid', $intTurnierId, array('order' => 'verein_name, team_name'));
    }

    /**
     * @param $intTurnierId
     * @return \Model\Collection|null|static
     */
    public static function findPublishedByTurnierOrderByStartnr($intTurnierId)
    {
        if (!$intTurnierId) {
            throw new \InvalidArgumentException("Turnier-ID erforderlich!");
        }
        $t = self::getTable();
        return static::findBy(array("$t.pid = ?", "$t.published = ?"), array($intTurnierId, 1), array('order' => "$t.startnr"));
    }

    public function __get($key)
    {
        switch ($key) {
            case 'kapitaen':
                return $this->getKapitaen();
            case 'kontakteAsArray':
                return $this->getKontakteAsArray();
            case 'liga':
                return $this->getRelated('pid');
            case 'team':
                return $this->getTeam();
            case 'trainerAsArray':
                return $this->getTrainerAsArray();
            case 'verein';
                return $this->getVerein();
            default:
                return parent::__get($key);
        }
    }

    public function __isset($key)
    {
        switch ($key) {
            case 'kapitaen':
                return $this->getKapitaen() != null;
            case 'kontakteAsArray':
                return $this->getKontakteAsArray() != null;
            case 'liga':
                return $this->liga != null;
            case 'team':
                return $this->getTeam() != null;
            case 'trainerAsArray':
                return $this->getTrainerAsArray() != null;
            case 'verein':
                return $this->getVerein() != null;
            default:
                return parent::__isset($key);
        }
    }

    public function __set($key, $value)
    {
        switch ($key) {
            case 'liga':
                parent::__set('pid', $value->id);
                break;
            default:
                parent::__set($key, $value);
        }
    }

    private function getKapitaen()
    {
        if ($this->kapitaen_name) {
            if (!$this->liga->saisonAbgelaufen) {
                return $this->emailOrText($this->kapitaen_email, $this->kapitaen_name);
            } else {
                return $this->kapitaen_name;
            }
        }
    }

    public function asArray()
    {
        $thisAsArray = $this->row();
        foreach (['kontakt', 'trainer'] as $property) {
            $thisAsArray[$property] = deserialize($thisAsArray[$property], true);
        }
        return $thisAsArray;
    }

    private function getKontakteAsArray()
    {
        if ($this->_kontakteAsArray == null) {
            $kontakte = deserialize($this->kontakt, true);
            $this->_kontakteAsArray = array();
            foreach ($kontakte as $i => $k) {
                if (!$this->liga->saisonAbgelaufen) {
                    $this->_kontakteAsArray[] = $this->emailOrText($k['email'], $k['name']);
                } else {
                    $this->_kontakteAsArray[] = $k['name'];
                }
            }
        }
        return $this->_kontakteAsArray;
    }

    private function getTeam()
    {
        if ($this->team_url) {
            return sprintf('<a href="%1$s" target="_blank">%2$s</a>', $this->team_url, $this->team_name);
        } else {
            return $this->team_name;
        }
    }

    private function getTrainerAsArray()
    {
        if ($this->_trainerAsArray == null) {
            $trainer = deserialize($this->trainer, true);
            $this->_trainerAsArray = array();
            foreach ($trainer as $i => $t) {
                if (!$this->liga->saisonAbgelaufen) {
                    $this->_trainerAsArray[] = $this->emailOrText($t['email'], $t['name']);
                } else {
                    $this->_trainerAsArray[] = $t['name'];
                }
            }
        }
        return $this->_trainerAsArray;
    }

    private function getVerein()
    {
        if ($this->verein_url) {
            return sprintf('<a href="%1$s" target="_blank">%2$s</a>', $this->verein_url, $this->verein_name);
        } else {
            return $this->verein_name;
        }
    }

    private function emailOrText($strEmail, $strText)
    {
        if ($strEmail) {
            return sprintf('<a href="{{email_url::mailto:%1$s}}">%2$s</a>', $strEmail, $strText);
        } else {
            return $strText;
        }
    }

}
