<?php

$GLOBALS['TL_DCA']['tl_td_erg_turnier'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'ptable' => 'tl_td_erg_saison',
        'enableVersioning' => true,
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary',
                'pid' => 'index',
            )
        ),
        'onsubmit_callback' => array(array('tl_td_erg_turnier', 'submitCallback')),
        'ondelete_callback' => array(array('tl_td_erg_turnier', 'deleteCallback')),
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 4,
            'flag' => 12,
            'fields' => array('bereich', 'bereichOrder', 'turnierartOrder', 'datum', 'titel'),
            'headerFields' => array('jahr'),
            'panelLayout' => 'filter;search,limit',
            'child_record_callback' => array('tl_td_erg_turnier', 'listeTurniere'),
            'child_record_class' => 'no_padding',
            'disableGrouping' => false,
            'filter' => \Tanzsport\Ergebnisarchiv::getLigabereicheByUser(),
        ),
        'label' => array
        (
            'fields' => array('bereich'),
            'format' => '%1$s'
        ),
        'global_operations' => array
        (/*
			'all' => array
			(
				'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
				'href' => 'act=select',
				'class' => 'header_edit_all',
				'attributes' => 'onclick="Backend.getScrollOffset();" accesskey="e"'
			)
			*/
        ),
        'operations' => array
        (
            'edit' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['edit'],
                'href' => 'act=edit',
                'icon' => 'edit.gif'
            ),
            'mannschaften' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['mannschaften'],
                'href' => 'table=tl_td_erg_turnier_mannschaft',
                'icon' => 'bundles/contaoformationen/icons/mannschaften.gif'
            ),
            /*
            'copy' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['copy'],
                'href' => 'act=copy',
                'icon' => 'copy.gif'
            ),*/
            'delete' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['delete'],
                'href' => 'act=delete',
                'icon' => 'delete.gif',
                'attributes' => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"',
                'button_callback' => array('tl_td_erg_turnier', 'deleteIcon')
            ),
            'toggle' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['toggle'],
                'icon' => 'visible.gif',
                'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
                'button_callback' => array('tl_td_erg_turnier', 'toggleIcon')
            ),
            'show' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['show'],
                'href' => 'act=show',
                'icon' => 'show.gif'
            )
        )
    ),

    // Palettes
    'palettes' => array
    (
        '__selector__' => array('wertungsrichter_erfassen', 'ergebnis_erfassen'),
        'default' => '{turnier_legend},bereich,datum,ort,turnierart,titel,wertungsrichter_anzahl;{turnierstaette_legend:hide},tst_halle,tst_telefon,tst_adresse;{zeitplan_legend:hide},zeiten_einlass,zeiten_beginn;{eintrittskarten_legend:hide},zeiten,karten;{vvk_legend:hide},vvk_text,vvk_anschrift,vvk_telefon,vvk_fax,vvk_email_adresse,vvk_email_text,vvk_online_url,vvk_online_text,vvk_bemerkungen;{anfahrt_legend:hide},anfahrt_text,anfahrt_url;{ergebnis_legend},ergebnis_erfassen;{wr_legend:hide},wertungsrichter_erfassen;{veroeffentlichung_legend},turnier_published,ergebnis_published,ergebnis_annulliert'
    ),

    // Subpalettes
    'subpalettes' => array
    (
        'wertungsrichter_erfassen' => 'wertungsrichter',
        'ergebnis_erfassen' => 'ergebnis_vorbehalt,ergebnis',
    ),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment",
        ),
        'pid' => array
        (
            'foreignKey' => 'tl_td_erg_saison.jahr',
            'sql' => "int(10) unsigned NOT NULL default '0'",
            'relation' => array('type' => 'belongsTo', 'load' => 'eager')
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),
        'bereich' => array
        (
            'sql' => "varchar(12) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['bereich'],
            'exclude' => false,
            'inputType' => 'select',
            'options_callback' => array('\Tanzsport\Ergebnisarchiv', 'getVerfuegbareLigabereicheMitLabelInternal'),
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => true, 'includeBlankOption' => true, 'submitOnChange' => true, 'tl_class' => 'w50'),
            'unique' => true,
            'reference' => &$GLOBALS['TL_LANG'][\Tanzsport\Ergebnisarchiv::LNG_KEY]['internal']
        ),
        'bereichOrder' => array
        (
            'sql' => "tinyint(1) unsigned NOT NULL default '0'",
        ),
        'turnierart' => array
        (
            'sql' => "varchar(6) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['turnierart'],
            'exclude' => false,
            'inputType' => 'select',
            'options_callback' => array('\Tanzsport\Ergebnisarchiv', 'getTurnierartenMitLabel'),
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => true, 'includeBlankOption' => false, 'tl_class' => 'w50'),
            'unique' => true,
            'reference' => &$GLOBALS['TL_LANG'][\Tanzsport\Ergebnisarchiv::LNG_KEY]
        ),
        'turnierartOrder' => array
        (
            'sql' => "tinyint(1) unsigned NOT NULL default '0'",
        ),
        'datum' => array
        (
            'sql' => "varchar(12) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['datum'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => false,
            'sorting' => false,
            'default' => date('d.m.Y', time()),
            'eval' => array('mandatory' => true, 'rgxp' => 'date', 'datepicker' => true, 'tl_class' => 'w50 wizard'),
            'unique' => true,
        ),
        'ort' => array
        (
            'sql' => "varchar(96) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['ort'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => true, 'maxlength' => 96, 'tl_class' => 'w50'),
        ),
        'titel' => array
        (
            'sql' => "varchar(48) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['titel'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => true, 'maxlength' => 48, 'tl_class' => 'w50'),
        ),
        'tst_halle' => array
        (
            'sql' => "varchar(96) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['tst_halle'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 96, 'tl_class' => 'w50'),
        ),
        'tst_telefon' => array
        (
            'sql' => "varchar(96) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['tst_telefon'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 96, 'tl_class' => 'w50'),
        ),
        'tst_adresse' => array
        (
            'sql' => "blob NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['tst_adresse'],
            'exclude' => false,
            'inputType' => 'textarea',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'rte' => 'tinyMCE', 'tl_class' => 'clr'),
        ),
        'zeiten_einlass' => array
        (
            'sql' => "varchar(96) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['zeiten_einlass'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 96, 'tl_class' => 'w100'),
        ),
        'zeiten_beginn' => array
        (
            'sql' => "blob NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['zeiten_beginn'],
            'exclude' => false,
            'inputType' => 'tdTurnierzeitenWidget',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'rows' => 6, 'tl_class' => 'w100 wizard'),
            'save_callback' => array(array('\Tanzsport\TurnierzeitenWidget', 'saveCallback')),
        ),
        'karten' => array
        (
            'sql' => "blob NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['karten'],
            'exclude' => false,
            'inputType' => 'tdKartenWidget',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'rows' => 6, 'tl_class' => 'clr'),
            'save_callback' => array(array('\Tanzsport\KartenWidget', 'saveCallback')),
        ),
        'vvk_text' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['vvk_text'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50'),
        ),
        'vvk_anschrift' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['vvk_anschrift'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50'),
        ),
        'vvk_telefon' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['vvk_telefon'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50'),
        ),
        'vvk_fax' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['vvk_fax'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50'),
        ),
        'vvk_email_text' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['vvk_email_text'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50'),
        ),
        'vvk_email_adresse' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['vvk_email_adresse'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50', 'rgxp' => 'email'),
        ),
        'vvk_online_text' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['vvk_online_text'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50'),
        ),
        'vvk_online_url' => array
        (
            'sql' => "varchar(256) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['vvk_online_url'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 96, 'tl_class' => 'w50', 'rgxp' => 'url'),
        ),
        'vvk_bemerkungen' => array
        (
            'sql' => "blob NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['vvk_bemerkungen'],
            'exclude' => false,
            'inputType' => 'textarea',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'rte' => 'tinyMCE', 'tl_class' => 'clr'),
        ),
        'anfahrt_text' => array
        (
            'sql' => "blob NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['anfahrt_text'],
            'exclude' => false,
            'inputType' => 'textarea',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'rte' => 'tinyMCE', 'tl_class' => 'clr'),
        ),
        'anfahrt_url' => array
        (
            'sql' => "varchar(256) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['anfahrt_url'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 96, 'tl_class' => 'w50', 'rgxp' => 'url'),
        ),
        'ergebnis_erfassen' => array
        (
            'sql' => "char(1) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['ergebnis_erfassen'],
            'exclude' => false,
            'default' => '',
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50', 'submitOnChange' => true),
        ),
        'ergebnis_vorbehalt' => array
        (
            'sql' => "char(1) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['ergebnis_vorbehalt'],
            'exclude' => false,
            'default' => '',
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
        ),
        'ergebnis_annulliert' => array
        (
            'sql' => "char(1) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['ergebnis_annulliert'],
            'exclude' => false,
            'default' => '',
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
        ),
        'ergebnis' => array
        (
            'sql' => 'blob NULL',
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['ergebnis'],
            'exclude' => false,
            'inputType' => 'tdFreiesturnierErgebnisWidget',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'tl_class' => 'w100 clr wizard', 'doNotCopy' => true),
            'save_callback' => array(array('\Tanzsport\FreiesturnierErgebnisWidget', 'saveCallback')),
        ),
        'wertungsrichter_anzahl' => array
        (
            'sql' => "tinyint(1) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['wertungsrichter_anzahl'],
            'exclude' => false,
            'inputType' => 'select',
            'options' => array('3', '5', '7', '9', '11', '13'),
            'search' => false,
            'sorting' => false,
            'default' => 5,
            'eval' => array('mandatory' => true, 'rgxp' => 'digit', 'tl_class' => 'w50', 'submitOnChange' => true),
            'unique' => true,
        ),
        'wertungsrichter_erfassen' => array
        (
            'sql' => "char(1) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['wertungsrichter_erfassen'],
            'exclude' => false,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50', 'submitOnChange' => true),
        ),
        'wertungsrichter' => array
        (
            'sql' => 'blob NULL',
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['wertungsrichter'],
            'exclude' => false,
            'inputType' => 'tdWertungsrichterWidget',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'tl_class' => 'clr wizard', 'doNotCopy' => true),
            'save_callback' => array(array('\Tanzsport\WertungsrichterWidget', 'saveCallback')),
        ),
        'turnier_published' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['turnier_published'],
            'exclude' => false,
            'filter' => true,
            'flag' => 1,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
            'sql' => "char(1) NOT NULL default ''"
        ),
        'ergebnis_published' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier']['ergebnis_published'],
            'exclude' => false,
            'filter' => true,
            'flag' => 1,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
            'sql' => "char(1) NOT NULL default ''"
        ),
    )
);

\System::loadLanguageFile('tl_td_erg');

class tl_td_erg_turnier extends Backend
{
    public function __construct()
    {
        parent::__construct();
        $this->import('BackendUser', 'User');
    }

    public function listeTurniere($arrRow)
    {
        $html = '<div class="tl_content_left">' . date('d.m.Y', $arrRow['datum']) . ' (' . $arrRow['ort'] . ') - ' . $arrRow['titel'] . '</div>';
        return $html;
    }

    public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
    {
        if (strlen(Input::get('tid'))) {
            $this->toggleVisibility(Input::get('tid'), (Input::get('state') == 1));
            $this->redirect($this->getReferer());
        }

        $href .= '&amp;tid=' . $row['id'] . '&amp;state=' . ($row['turnier_published'] ? '' : 1);

        if (!$row['turnier_published']) {
            $icon = 'invisible.gif';
        }

        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '"' . $attributes . '>' . Image::getHtml($icon, $label) . '</a> ';
    }

    public function toggleVisibility($intId, $blnVisible)
    {
        $objVersions = new Versions('tl_td_erg_turnier', $intId);
        $objVersions->initialize();

        if (is_array($GLOBALS['TL_DCA']['tl_td_erg_turnier']['fields']['turnier_published']['save_callback'])) {
            foreach ($GLOBALS['TL_DCA']['tl_td_erg_turnier']['fields']['turnier_published']['save_callback'] as $callback) {
                if (is_array($callback)) {
                    $this->import($callback[0]);
                    $blnVisible = $this->$callback[0]->$callback[1]($blnVisible, $this);
                } elseif (is_callable($callback)) {
                    $blnVisible = $callback($blnVisible, $this);
                }
            }
        }

        // Update the database
        $this->Database->prepare("UPDATE tl_td_erg_turnier SET tstamp=" . time() . ", turnier_published='" . ($blnVisible ? 1 : '') . "' WHERE id=?")
            ->execute($intId);

        $objVersions->create();
    }

    public static function submitCallback(DC_Table $dc)
    {
        \Database::getInstance()->prepare("UPDATE tl_td_erg_turnier SET bereichOrder = ?, turnierartOrder = ? WHERE id = ?")
            ->execute(array(
                \Tanzsport\ErgebnisArchiv::getSortIndexBereich($dc->activeRecord->bereich),
                \Tanzsport\Ergebnisarchiv::getSortIndexTurnierart($dc->activeRecord->turnierart),
                $dc->activeRecord->id
            ));
    }

    public static function deleteCallback(DC_Table $dc)
    {
        $mannschaften = \Tanzsport\FreiesturnierMannschaftModel::findBy('pid', $dc->activeRecord->id);
        if ($mannschaften != null) {
            foreach ($mannschaften as $mannschaft) {
                $mannschaft->delete();
            }
        }
    }

    public function deleteIcon($row, $href, $label, $title, $icon, $attributes)
    {
        if (!$this->User->isAdmin) {
            return;
        }
        return '<a href="' . $this->addToUrl('&amp;act=delete&amp;id=' . $row['id']) . '" title="' . specialchars($title) . '"' . $attributes . '>' . Image::getHtml($icon, $label) . '</a> ';
    }
}
