<?php
declare(strict_types=1);

namespace Tanzsport\ContaoFormationenBundle\Controller\Api;

use Contao\ModuleModel;
use Contao\StringUtil;
use Tanzsport\FreiesturnierModel;
use Tanzsport\LigaModel;
use Tanzsport\SaisonModel;

trait LoadLigenTrait
{
    private function loadLigen(ModuleModel $model): array
    {
        $items = [];
        $turnierarten = StringUtil::deserialize($model->td_erg_turnierarten, true);

        $saison = null;
        if (!empty($turnierarten)) {
            $saison = SaisonModel::findLatestPublished();
        }

        $ligen = null;
        if ($saison && !empty($turnierarten)) {
            $ligen = LigaModel::findBySaison($saison, $turnierarten);
        }

        if ($ligen) {
            foreach ($ligen as $liga) {
                /**
                 * @var $liga LigaModel
                 */
                $array = $liga->row();
                $array['bereichTitel'] = $liga->bereichTitel;
                $array['titel'] = $liga->titel;
                $array['isTurnier'] = false;
                $items[] = $array;
            }
        }

        $turniere = null;
        if ($saison && !empty($turnierarten)) {
            $turniere = FreiesturnierModel::findBySaison($saison, $turnierarten);
        }

        if ($turniere) {
            foreach ($turniere as $turnier) {
                /**
                 * @var $turnier FreiesturnierModel
                 */
                $array = $turnier->asArray();
                $array['bereichTitel'] = $turnier->bereichTitel;
                $array['isTurnier'] = true;
                $items[] = $array;
            }
        }

        return $items;
    }
}
