<?php
declare(strict_types=1);

namespace Tanzsport\ContaoFormationenBundle\Controller\Api;

use Contao\Config;
use Contao\CoreBundle\Framework\ContaoFramework;
use Psr\Log\LoggerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpKernel\KernelInterface;

abstract class AbstractApiController extends AbstractController
{

    protected LoggerInterface $contaoErrorLogger;
    protected ContaoFramework $framework;
    protected KernelInterface $kernel;

    public function __construct(ContaoFramework $framework, LoggerInterface $contaoErrorLogger, KernelInterface $kernel)
    {
        $this->framework = $framework;
        $this->framework->initialize(true);
        $this->contaoErrorLogger = $contaoErrorLogger;
        $this->kernel = $kernel;

        $GLOBALS['TL_LANGUAGE'] = 'de';
    }

    protected function getConfig(string $key)
    {
        return $this->framework->getAdapter(Config::class)->get($key);
    }

    protected function isDev(): bool
    {
        return $this->kernel->getEnvironment() === 'dev';
    }
}
