import { writable } from "svelte/store";
import type { Ligabereiche } from "../model/models";
import { configuration } from "./configuration";

export const ligabereicheState = writable<Ligabereiche | undefined>();
export const ligabereichSelection = writable<string | undefined>();

export const loadLigabereiche = async (jahr?: number) => {
  try {
    ligabereicheState.set(undefined);
    const url =
      configuration.baseUri +
      `/api/v2/ergebnisse/formationen/ligabereiche/${configuration.sparte}${
        jahr !== undefined ? `/${jahr}` : ""
      }`;
    const response = await fetch(url);

    if (!response.ok) {
      throw new Error(
        `Failed to fetch ligabereiche: ${response.status} ${response.statusText}`
      );
    }

    const data = await response.json();
    ligabereicheState.set(data);
  } catch (err) {
    console.error("Error loading ligabereiche:", err);
  }
};
