import { Rundentyp } from "../model/models";
import { configuration } from "../stores/configuration";

export function getColor(runde: Rundentyp): string | undefined {
  if (configuration.sparte === "stdlat") {
    switch (runde) {
      case Rundentyp.FINALE:
      case Rundentyp.A_FINALE:
        return `#c094bc`;
      case Rundentyp.B_FINALE:
        return `#d7bed5`;
      case Rundentyp.ZWISCHENRUNDE:
      case Rundentyp.ZWISCHENRUNDE2:
        return `#e6d4e4`;
      default:
        return undefined;
    }
  } else {
    switch (runde) {
      case Rundentyp.FINALE:
      case Rundentyp.A_FINALE:
        return `#f6bb94`;
      case Rundentyp.B_FINALE:
        return `#f9d6bf`;
      case Rundentyp.ZWISCHENRUNDE:
      case Rundentyp.ZWISCHENRUNDE2:
        return `#f9d6bf`;
      default:
        return undefined;
    }
  }
}
