<?php
declare(strict_types=1);

namespace Tanzsport\ContaoEventListBundle\Modules;

use Contao\BackendTemplate;
use Contao\Files;
use Contao\FilesModel;
use Contao\Module;
use Contao\System;
use Monolog\Logger;
use Tanzsport\ExcelEventListReader\ExcelEventListReader;

class ModuleEventliste extends Module
{

    protected $strTemplate = 'mod_eventliste';

    public function generate()
    {
        $request = System::getContainer()->get('request_stack')->getCurrentRequest();

        if ($request && System::getContainer()->get('contao.routing.scope_matcher')->isBackendRequest($request)) {
            $objTemplate = new BackendTemplate('be_wildcard');
            $objTemplate->wildcard = '### ' . $GLOBALS['TL_LANG']['FMD']['td_eventliste'][0] . ' ###';
            $objTemplate->title = $this->headline;
            $objTemplate->id = $this->id;
            $objTemplate->link = $this->name;
            $objTemplate->href = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        $this->loadLanguageFile('td_eventliste');
        return parent::generate();
    }

    protected function compile()
    {
        global $objPage;

        $this->Template->events = [];
        $this->Template->dateFormat = $objPage->dateFormat;

        $container = System::getContainer();

        /**
         * @var $logger Logger
         */
        $logger = $container->get('monolog.logger.contao');

        if ($this->singleSRC) {
            $objFile = FilesModel::findByPk($this->singleSRC);
            if ($objFile != null) {
                try {
                    $reader = new ExcelEventListReader($container->getParameter('kernel.project_dir') . '/' . $objFile->path);
                    $events = $reader->readEventsInWorksheet((int)$this->td_eventliste_sheet);
                    if ($this->td_eventliste_sort) {
                        $events->sort();
                    }
                    if ($this->td_eventliste_current) {
                        $events = $events->onlyCurrent();
                    }
                    $this->Template->events = $events;
                } catch (\Exception $e) {
                    $logger->error("Could not read Excel file in mod_eventliste, id={$this->id}", ['execption' => $e]);
                }
            } else {
                $logger->warn("Could not find file model by singleSRC in mod_eventliste, id={$this->id}");
            }
        }
    }
}
