<?php
declare(strict_types=1);

namespace Tanzsport\ContaoDtvNewsBundle\Hook;

use Codefog\NewsCategoriesBundle\Model\NewsCategoryModel;
use Codefog\NewsCategoriesBundle\NewsCategoriesManager;
use Contao\CoreBundle\Framework\ContaoFramework;
use Contao\CoreBundle\ServiceAnnotation\Hook;
use Contao\FrontendTemplate;
use Contao\Input;
use Contao\Module;
use Contao\System;
use NewsCategories\NewsCategories;

class ArticleParser
{

    private ContaoFramework $framework;
    private NewsCategoriesManager $newsCategoriesManager;
    private string $themeDirectory = 'deutscher_tanzsportverband';

    public function __construct(ContaoFramework $framework, NewsCategoriesManager $newsCategoriesManager)
    {
        $this->framework = $framework;
        $this->framework->initialize(true);
        $this->newsCategoriesManager = $newsCategoriesManager;
    }

    /**
     * @Hook("parseArticles")
     *
     * @param FrontendTemplate $template
     * @param array $newsEntry
     * @param Module $module
     * @return void
     */
    public function addCategoriesAndDefaultImage(FrontendTemplate $template, array $newsEntry, Module $module)
    {
        $this->getSystem()->loadLanguageFile('td_news');

        if ($template->categories == null || empty($template->categories)) {
            $template->tdnewsCategory = $GLOBALS['TL_LANG']['td_news']['defaultCategory'];
            $template->tdnewsCategoryClass = $GLOBALS['TL_LANG']['td_news']['defaultCategoryClass'];
            $template->tdnewsCategoryTitle = $GLOBALS['TL_LANG']['td_news']['defaultCategory'];
            $this->addDefaultImage($template, $GLOBALS['TL_LANG']['td_news']['defaultCategoryAlias'], $GLOBALS['TL_LANG']['td_news']['defaultCategory']);
        } else {
            if (count($template->categories) == 1) {
                $arrCategoryKeys = array_keys($template->categories);
                $category = $template->categories[$arrCategoryKeys[0]];
                $template->tdnewsCategory = $category['frontendTitle'];
                $template->tdnewsCategoryClass = 'newscat-' . $category['alias'];
                $template->tdnewsCategoryTitle = $category['frontendTitle'];
                $this->addDefaultImage($template, $category['alias'], $category['frontendTitle']);
            } else {
                $objFilteredCategory = $this->getFilteredCategory();
                if ($objFilteredCategory) {
                    $template->tdnewsCategory = $objFilteredCategory->frontendTitle;
                    $template->tdnewsCategoryClass = 'newscat-' . $objFilteredCategory->alias;
                    $template->tdnewsCategoryTitle = $objFilteredCategory->frontendTitle;
                    $this->addDefaultImage($template, $objFilteredCategory->alias, $objFilteredCategory->frontendTitle);
                } else {
                    $template->tdnewsCategory = $GLOBALS['TL_LANG']['td_news']['multipleCategories'];
                    $template->tdnewsCategoryClass = $GLOBALS['TL_LANG']['td_news']['multipleCategoriesClass'];
                    $categoryTitle = '';
                    $first = true;
                    foreach ($template->categories as $category) {
                        if (!$first) {
                            $categoryTitle .= ' / ';
                        }
                        $categoryTitle .= $category['frontendTitle'];
                        $first = false;
                    }
                    $template->tdnewsCategoryTitle = $categoryTitle;
                    $this->addDefaultImage($template, $GLOBALS['TL_LANG']['td_news']['multipleCategoriesAlias'], $GLOBALS['TL_LANG']['td_news']['multipleCategories']);
                }
            }
        }
    }

    private function addDefaultImage(FrontendTemplate $objTemplate, $strAlias, $strTitle)
    {
        $objTemplate->tdnewsDefaultImage = '<figure class="news_platzhalter_' . $strAlias . '"><img src="' . $this->getImagePath() . '/news_platzhalter_' . $strAlias . '_' . $GLOBALS['TL_LANGUAGE'] . '.jpg" alt="' . $strTitle . '" /></figure>';
    }

    private function getImagePath()
    {
        return sprintf('/files/themes/%1$s/images', $this->themeDirectory);
    }

    private function getFilteredCategory()
    {
        $param = $this->newsCategoriesManager->getParameterName();
        $adapterModel = $this->framework->getAdapter(NewsCategoryModel::class);

        if (Input::get($param)) {
            return $adapterModel->findPublishedByIdOrAlias(Input::get($param));
        }

        return null;
    }

    /**
     * @return \Contao\System
     */
    private function getSystem()
    {
        return $this->framework->getAdapter(System::class);
    }
}
