function initEinzel(form, remote) {
	initTypenEinzel(form);
	initTurniereEinzel(form, remote);
}

function initTypenEinzel(form) {
	typenChangedEinzel(form);
	$(form + ' input[name^="typ"]').on('click', function () {
		typenChangedEinzel(form);
	});
}

function typenChangedEinzel(form) {
	var inland = false;
	$(form + ' input[name^="typ"]').each(function () {
		if ($(this).val() == 'OT' || $(this).val() == 'ET') {
			if ($(this).is(':checked')) {
				inland = true;
			}
		}
	});
	toggleInlandEinzel(form, inland);
}

function toggleInlandEinzel(form, active) {
	if (!active) {
		$(form + ' input[name^="plz"]').val('').attr('disabled', true);
		$(form + ' input[name^="l"]').attr('checked', false).attr('disabled', true);
		$(form + ' select[name="t1gruppe"]').val('').attr('disabled', true);
		$(form + ' select[name="t2gruppe"]').val('').attr('disabled', true);
		$(form + ' select[name="t1klasse"]').val('').attr('disabled', true);
		$(form + ' select[name="t2klasse"]').val('').attr('disabled', true);
		$(form + ' select[name="t1art"]').val('').attr('disabled', true);
		$(form + ' select[name="t2art"]').val('').attr('disabled', true);
		$(form + ' input[name="konjunktion"]').val('').attr('disabled', true);
		$(form + ' .landesverbaende').addClass('disabled');
		$(form + ' .konjunktion').addClass('disabled');
	}
	else {
		$(form + ' input[name^="plz"]').attr('disabled', false);
		$(form + ' input[name^="l"]').attr('disabled', false);
		$(form + ' select[name="t1gruppe"]').attr('disabled', false);
		$(form + ' select[name="t2gruppe"]').attr('disabled', false);
		$(form + ' input[name="konjunktion"]').attr('disabled', false);
		$(form + ' .landesverbaende').removeClass('disabled');
		$(form + ' .konjunktion').removeClass('disabled');
	}
}

function initTurniereEinzel(form, remote) {
	bindStartklasseEinzel(form, remote, 't1gruppe', 't1klasse', 't1art');
	bindStartklasseEinzel(form, remote, 't2gruppe', 't2klasse', 't2art');
	bindTurnierartEinzel(form, remote, 't1gruppe', 't1klasse', 't1art');
	bindTurnierartEinzel(form, remote, 't2gruppe', 't2klasse', 't2art');
}

function bindStartklasseEinzel(form, remote, source, target1, target2) {
	var select = $(form + ' select[name="' + source + '"]');
	if (select.val() == '') {
		replaceOptions(target1, null, false);
		disableSelect(target1);
	}
	select.on('change', function () {
		if ($(this).val() != '') {
			$.get(remote, {q: 'sk', p: $(this).val()}, function (data) {
				replaceOptions(target1, data, false)
			}, 'json');
			enableSelect(target1);
		}
		else {
			replaceOptions(target1, null, false);
			disableSelect(target1);
			replaceOptions(target2, null, false)
			disableSelect(target2);
		}
	});
}

function bindTurnierartEinzel(form, remote, source1, source2, target) {
	var select = $(form + ' select[name="' + source2 + '"]');
	if (select.val() == '') {
		replaceOptions(target);
		disableSelect(target);
	}
	select.on('change', function () {
		var s1 = $('select[name="' + source1 + '"]');
		if ($(this).val() != '') {
			$.get(remote, {q: 'ta', p1: s1.val(), p2: $(this).val()}, function (data) {
				replaceOptions(target, data, false)
			}, 'json');
			enableSelect(target);
		}
		else {
			replaceOptions(target, null, false);
			disableSelect(target);
		}
	});
}
