<?php

namespace Tanzsport\ContaoDtvApiBundle\Controller\FrontendModule;

use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\ModuleModel;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @FrontendModule("td_eventsearch",
 *     category="td",
 *     template="mod_eventsearch",
 *     renderer="forward"
 * )
 */
class EventSearchFrontendModuleController extends AbstractFrontendModuleController
{
    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $GLOBALS['TL_HEAD'][] = Template::generateStyleTag('bundles/contaodtvapi/progress.css');
        $GLOBALS['TL_HEAD'][] = Template::generateScriptTag('bundles/contaodtvapi/events/search.js', false, null, null, 'anonymous');
        $template->eventsearchType = $model->td_eventsearch_type;
        return $template->getResponse();
    }
}
