import { svelte } from "@sveltejs/vite-plugin-svelte";

export const viteBaseConfig = {
  plugins: [
    svelte({
      emitCss: false,
      compilerOptions: {
        css: "injected",
        hydratable: true
      },
    }),
  ],
  build: {
    outDir: "../src/Resources/public/events",
    emptyOutDir: true,
    manifest: false,
    rollupOptions: {
      input: {
        index: "./index.html",
        bsw: "./bsw.html",
        jmc: "./jmc.html",
        einzel: "./einzel.html",
        formation: "./formation.html",
        zuschauer: "./zuschauer.html",
      },
      output: {
        preserveModules: false,
        entryFileNames: "[name].js",
        chunkFileNames: "[name].js",
      },
    },
  },
};
