import notEmpty from "../lib/notEmpty";

const keys = [
  "dateFrom",
  "dateTo",
  "zipCodeFrom",
  "zipCodeTo",
  "zipCodeNear",
  "zipCodeDistance",
  "selectionLtv",
  "selectionAltersklasse",
  "selectionWettbewerbsart",
  "selectionTurnierart",
  "selectionTurnierform",
  "leistungsklasse",
  "altersklasse",
  "turnierart",
  "leistungsklasse2",
  "altersklasse2",
  "turnierart2",
  "conjunction",
  "allItems",
];

function shortenKeys(o: object) {
  return Object.fromEntries(
    Object.entries(o)
      .map((e) => {
        if (Array.isArray(e[1]) && e[1].length === 0) return undefined;
        const idx = keys.indexOf(e[0]);
        const key = idx >= 0 ? "_" + idx : e[0];
        return [key, e[1]];
      })
      .filter(notEmpty)
  );
}

function longKeys(o: object) {
  return Object.fromEntries(
    Object.entries(o)
      .map((e) => {
        if (e[0].charAt(0) === "_")
          return [keys[parseInt(e[0].substring(1))], e[1]];
        else return e;
      })
      .filter(notEmpty)
  );
}

export function filterParse(o: string): object | undefined {
  try {
    const d = JSON.parse(window.atob(o.charAt(0) === "#" ? o.substring(1) : o));
    if (typeof d !== "object") return;

    return longKeys(d);
  } catch (e) {
    // ignore
  }
}

export function filterStringify(o: object) {
  return JSON.stringify(shortenKeys(o));
}
