import { writable } from "svelte/store";
import baseUrl from "../lib/baseUrl";
import type RestResult from "../types/RestResult";
import type Tags from "../types/Tags";

export async function loadParameter(filters: number[]) {
  tags.set({ loading: true });
  const response = await fetch(
    baseUrl + "/events/tags?" + filters.map((f) => "filter=" + f).join("&")
  );
  const data = (await response.json()) as Tags;
  tags.set({ data });
}

export const tags = writable<RestResult<Tags>>({});
