import { writable } from "svelte/store";
import baseUrl from "../lib/baseUrl";
import type RestResult from "../types/RestResult";
import type SearchRequest from "../types/SearchRequest";
import type SearchResult from "../types/SearchResult";

export function resetSearch() {
  searchResult.set({});
}

export async function searchEvents(request: SearchRequest) {
  try {
    searchResult.update((i) => ({ ...i, loading: true }));
    const response = await fetch(baseUrl + "/events/search", {
      method: "POST",
      body: JSON.stringify(request),
      headers: { "Content-Type": "application/json" },
    });
    if (response.ok) {
      const data: SearchResult = await response.json();
      searchResult.set({ data });
    } else {
      searchResult.set({ error: new Error("Serverfehler") });
    }
  } catch (error) {
    searchResult.set({ error: error as Error });
  }
}

export async function downloadPdf(request: SearchRequest) {
  const response = await fetch(baseUrl + "/events/search/pdf", {
    method: "POST",
    body: JSON.stringify(request),
    headers: { "Content-Type": "application/json" },
  });
  const blob = await response.blob();
  const url = window.URL.createObjectURL(blob);
  const link = document.createElement("a");
  link.href = url;
  link.target = "_blank";
  link.click();
}

export const searchResult = writable<RestResult<SearchResult>>({});
