<?php

namespace Tanzsport\ContaoDtvApiBundle\UI;

use Contao\FrontendTemplate;
use Contao\Pagination;

class FormPagination extends Pagination
{
    private $blnZeroBased;

    public function __construct($intRows, $intPerPage, $intNumberOfLinks = 7, $strParameter = 'seite', $blnZeroBased = true)
    {
        parent::__construct($intRows, $intPerPage, $intNumberOfLinks, $strParameter, new FrontendTemplate('formpagination'));
        $this->blnZeroBased = $blnZeroBased;

        $post = array();
        foreach ($_POST as $postVar => $postValue) {
            if ($postVar != $strParameter) {
                $var = \Input::post($postVar);
                $post[$postVar] = $var;
            }
        }
        $this->objTemplate->postVars = $post;

        if (\Input::post($strParameter) != '' && \Input::post($strParameter) > 0) {
            if ($this->blnZeroBased) {
                $this->intPage = \Input::post($strParameter) + 1;
            } else {
                $this->intPage = \Input::post($strParameter);
            }
        }
        $this->intTotalPages = ceil($this->intRows / $this->intRowsPerPage);

        $this->objTemplate->strParameter = $this->strParameter;
        $this->objTemplate->intPage = $this->intPage;
        $this->objTemplate->intTotalPages = $this->intTotalPages;

        if ($this->blnZeroBased) {
            $this->objTemplate->firstPageIndex = 0;
            $this->objTemplate->lastPageIndex = $this->intTotalPages - 1;
            $this->objTemplate->previousPageIndex = $this->intPage - 2;
            $this->objTemplate->nextPageIndex = $this->intPage;
        } else {
            $this->objTemplate->firstPageIndex = 1;
            $this->objTemplate->lastPageIndex = $this->intTotalPages;
            $this->objTemplate->previousPageIndex = $this->intPage - 1;
            $this->objTemplate->nextPageIndex = $this->intPage + 1;
        }
    }

    public function getItemsAsString($strSeparator = ' ')
    {
        $arrLinks = array();

        $intNumberOfLinks = floor($this->intNumberOfLinks / 2);
        $intFirstOffset = $this->intPage - $intNumberOfLinks - 1;

        if ($intFirstOffset > 0) {
            $intFirstOffset = 0;
        }

        $intLastOffset = $this->intPage + $intNumberOfLinks - $this->intTotalPages;

        if ($intLastOffset < 0) {
            $intLastOffset = 0;
        }

        $intFirstLink = $this->intPage - $intNumberOfLinks - $intLastOffset;

        if ($intFirstLink < 1) {
            $intFirstLink = 1;
        }

        $intLastLink = $this->intPage + $intNumberOfLinks - $intFirstOffset;

        if ($intLastLink > $this->intTotalPages) {
            $intLastLink = $this->intTotalPages;
        }

        for ($i = $intFirstLink; $i <= $intLastLink; $i++) {
            if ($i == $this->intPage) {
                $arrLinks[] = sprintf('<li><button class="current" name="%1$s" value="%2$s">%3$s</button></li>', $this->strParameter, $i - 1, $i);
                continue;
            }

            $arrLinks[] = sprintf('<li><button name="%1$s" value="%2$s">%3$s</button></li>', $this->strParameter, $i - 1, $i);
        }

        return implode($strSeparator, $arrLinks);
    }

}
