import { defineConfig } from "vite";
import { svelte } from "@sveltejs/vite-plugin-svelte";

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [
    svelte({
      emitCss: false,
      compilerOptions: {
        css: "injected",
        hydratable: true
      },
    }),
  ],
  build: {
    outDir: "../src/Resources/public/events",
    emptyOutDir: true,
    manifest: false,
    rollupOptions: {
      input: {
        index: "./index.html",
        bsw: "./bsw.html",
        jmc: "./jmc.html",
        einzel: "./einzel.html",
        formation: "./formation.html",
      },
      output: {
        preserveModules: false,
        entryFileNames: "[name].js",
        chunkFileNames: "[name].js",
      },
    },
  },
});
