import SearchBsw from "./pages/SearchBsw.svelte";
import SearchEinzel from "./pages/SearchEinzel.svelte";
import SearchFormation from "./pages/SearchFormation.svelte";
import SearchJmc from "./pages/SearchJmc.svelte";

var observer = new MutationObserver(() => {
  if (mount()) observer.disconnect();
});

observer.observe(document, {
  attributes: false,
  childList: true,
  characterData: false,
  subtree: true,
});

function mount() {
  const target = document.getElementById("mount-search");
  if (target) {
    const type = target.getAttribute("data-type");

    switch (type) {
      case "BSW":
        new SearchBsw({ target, hydrate: true });
        break;
      case "JMC":
        new SearchJmc({ target, hydrate: true });
        break;
      case "Formation":
        new SearchFormation({ target, hydrate: true });
        break;
      default:
        new SearchEinzel({ target, hydrate: true });
        break;
    }
    return true;
  }
}
