export function accordion(node: HTMLElement, isOpen: boolean) {
  let initialHeight = node.offsetHeight;
  node.style.height = isOpen ? "auto" : "0";
  node.style.overflow = "hidden";
  if (!isOpen) node.style.visibility = "hidden";
  node.style.transition = "height 0.25s ease-in-out";
  return {
    update(isOpen: boolean) {
      if (isOpen) {
        node.style.visibility = "visible";
        node.style.height = initialHeight + "px";
      } else {
        node.style.height = "0";
        setTimeout(() => (node.style.visibility = "hidden"), 250);
      }
    },
  };
}
