<?php
declare(strict_types=1);

namespace Tanzsport\ContaoDtvApiBundle\Migration;

use Contao\CoreBundle\Migration\AbstractMigration;
use Contao\CoreBundle\Migration\MigrationResult;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Schema\AbstractSchemaManager;

class SwitchToEventSearchMigration extends AbstractMigration
{

    private Connection $connection;

    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    public function shouldRun(): bool
    {
        $stmt = $this->connection->prepare(
            "SELECT id FROM tl_module WHERE type IN ('td_turniereinzelsuche', 'td_turnierformationsuche', 'td_turnierjmdsuche')"
        );
        return $stmt->executeQuery()->rowCount() > 0;
    }

    public function run(): MigrationResult
    {
        $this->connection->beginTransaction();
        try {
            $stmt = $this->connection->prepare(
                "UPDATE tl_module SET type = 'td_eventsearch' WHERE type IN ('td_turniereinzelsuche', 'td_turnierformationsuche', 'td_turnierjmdsuche')"
            );
            $stmt->execute();
            return $this->createResult($this->connection->commit(), "Switched modules to td_eventsearch");
        } catch (\Exception $e) {
            $this->connection->rollBack();
            return $this->createResult(false, $e->getMessage());
        }
    }
}
