<?php
declare(strict_types=1);

namespace Tanzsport\ContaoDtvApiBundle\Migration;

use Contao\CoreBundle\Migration\AbstractMigration;
use Contao\CoreBundle\Migration\MigrationResult;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Schema\AbstractSchemaManager;

class RemoveApiColumnsFromTlModuleMigration extends AbstractMigration
{

    private static array $columns = [
        'tl_module' => 'td_api_endpoint',
        'tl_module' => 'td_api_cache'
    ];

    private Connection $connection;
    private AbstractSchemaManager $manager;

    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
        $this->manager = $connection->getSchemaManager();
    }

    public function shouldRun(): bool
    {
        $exists = false;
        foreach (self::$columns as $table => $column) {
            if ($this->exists($table, $column)) {
                $exists = true;
            }
        }
        return $exists;
    }

    public function run(): MigrationResult
    {
        $dropped = [];
        foreach (self::$columns as $table => $column) {
            if ($this->exists($table, $column)) {
                $this->connection->executeQuery("ALTER TABLE `{$table}` DROP COLUMN `{$column}`");
                $dropped[] = "{$table}.{$column}";
            }
        }

        $info = join(', ', $dropped);

        return $this->createResult(true, "Dropped columns {$info}");
    }


    private function exists($table, $column): bool
    {
        if ($this->manager->tablesExist($table)) {
            return count(array_filter($this->manager->listTableColumns($table), function ($def) use ($column) {
                    return $def->getName() == $column;
                })) > 0;
        } else {
            return false;
        }
    }
}
