<?php
declare(strict_types=1);

namespace Tanzsport\ContaoDtvApiBundle\Factory;

use Contao\CoreBundle\Framework\ContaoFramework;
use Tanzsport\API\Lehrgang\LehrgangsDatenbankService;
use Tanzsport\API\Turnier\EinzelwettbewerbDatenbankService;
use Tanzsport\API\Turnier\FormationswettbewerbDatenbankService;
use Tanzsport\API\Turnier\JmdWettbewerbDatenbankService;
use Tanzsport\API\Verein\VereinsDatenbankService;

class ApiServiceFactory
{

    public function __construct(ContaoFramework $framework)
    {
        $framework->initialize(true);
    }

    public function createEinzelwettbewerbDatenbankService(): EinzelwettbewerbDatenbankService
    {
        return new EinzelwettbewerbDatenbankService($this->getEndpoint(), $this->isUseCaching(), $this->getTmpDir(), 'TD_TDBE_1', 365, 'tdkey2014$dtv.de');
    }

    public function createFormationswettbewerbDatenbankService(): FormationswettbewerbDatenbankService
    {
        return new FormationswettbewerbDatenbankService($this->getEndpoint(), $this->isUseCaching(), $this->getTmpDir(), 'TD_TDBF_1', 365, 'tdkey2014$dtv.de');
    }

    public function createJmdWettbewerbDatenbankService(): JmdWettbewerbDatenbankService
    {
        return new JmdWettbewerbDatenbankService($this->getEndpoint(), $this->isUseCaching(), $this->getTmpDir(), 'TD_TDBJ_1', 365, 'tdkey2014$dtv.de');
    }

    public function createLehrgangsdatenbankService(): LehrgangsDatenbankService
    {
        return new LehrgangsDatenbankService($this->getEndpoint(), $this->isUseCaching(), $this->getTmpDir(), 'TD_LDB_1', 365, 'tdkey2014$dtv.de');
    }

    public function createVereinsdatenbankService(): VereinsDatenbankService
    {
        return new VereinsDatenbankService($this->getEndpoint(), $this->isUseCaching(), $this->getTmpDir());
    }

    private function getEndpoint(): string
    {
        $fromConfig = $GLOBALS['TL_CONFIG']['td_api_endpoint'];
        return $fromConfig ?: 'https://appsrv.tanzsport.de/td/api/';
    }

    private function getTmpDir(): string
    {
        return TL_ROOT . '/system/tmp';
    }

    private function isUseCaching(): bool
    {
        return (bool)$GLOBALS['TL_CONFIG']['td_api_caching'];
    }
}
