<?php
declare(strict_types=1);

namespace Tanzsport\ContaoDtvApiBundle\Controller\FrontendModule;

use Contao\Config;
use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Framework\ContaoFramework;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\FrontendTemplate;
use Contao\Input;
use Contao\ModuleModel;
use Contao\Template;
use Psr\Log\LoggerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Tanzsport\API\Verein\VereinsDatenbankService;

/**
 * @FrontendModule("td_vereinsleser",
 *     category="td",
 *     template="mod_vereinsleser",
 *     renderer="forward"
 * )
 */
class VereinsLeserFrontendModuleController extends AbstractFrontendModuleController
{

    private VereinsDatenbankService $service;
    private LoggerInterface $contaoErrorLogger;
    private ContaoFramework $framework;

    public function __construct(VereinsDatenbankService $service, LoggerInterface $contaoErrorLogger, ContaoFramework $framework)
    {
        $this->service = $service;
        $this->contaoErrorLogger = $contaoErrorLogger;
        $this->framework = $framework;
        $this->framework->initialize(true);
    }

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $number = $this->getRequestedNummer($request);
        if (!$number) {
            throw $this->createNotFoundException();
        }

        try {
            $verein = $this->service->findVerein($number);
            if ($verein) {
                $this->getPageModel()->title = $verein['name'];
                $template->verein = $verein;
            }
            return $template->getResponse()->setPrivate();
        } catch (\Throwable $e) {
            $this->contaoErrorLogger->log('error', 'Error querying Vereinsdatenbank', ['exception' => $e]);
            $template = new FrontendTemplate('mod_api_error');
            $template->message = $e->getMessage();
            return $template->getResponse()->setPrivate();
        }
    }

    private function isUseAutoItem(): bool
    {
        return $this->framework->getAdapter(Config::class)->get('useAutoItem');
    }

    private function getRequestedNummer(Request $request): ?string {
        if ($this->isUseAutoItem()) {
            return $this->framework->getAdapter(Input::class)->get('auto_item');
        } else {
            return $request->query->get('nr');
        }
    }
}
