<?php
declare(strict_types=1);

namespace Tanzsport\ContaoDtvApiBundle\Controller\FrontendModule;

use Contao\ModuleModel;

trait TurnierSucheTrait
{

    private function generateVereinsLinkBase(ModuleModel $model)
    {
        if ($model->jumpTo && ($targetPage = $model->getRelated('jumpTo')) !== null) {
            /**
             * @var PageModel $targetPage
             */
            return $targetPage->getFrontendUrl() . ($this->isUseAutoItem() ? "/" : '') . ($this->isUseAutoItem() ? '' : '?nr=');
        }
    }

    private function isUseAutoItem(): bool
    {
        return (bool)$GLOBALS['TL_CONFIG']['useAutoItem'];
    }
}
