<?php

namespace Tanzsport\ContaoDtvApiBundle\Controller\FrontendModule;

use Contao\Config;
use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Framework\ContaoFramework;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\Input;
use Contao\ModuleModel;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @FrontendModule("td_eventsearch",
 *     category="td",
 *     template="mod_eventsearch",
 *     renderer="forward"
 * )
 */
class EventSearchFrontendModuleController extends AbstractFrontendModuleController
{

    private ContaoFramework $framework;

    public function __construct(
        ContaoFramework  $framework
    )
    {
        $this->framework = $framework;
        $this->framework->initialize(true);
    }

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        if ($this->isUseAutoItem()) {
            // Parameter für die Vereinssuche; wird hier im Controller nicht benötigt, muss aber ermittelt werden,
            // da sonst es sonst eine 404 Response gibt
            $this->framework->getAdapter(Input::class)->get('auto_item');
        }

        $GLOBALS['TL_HEAD'][] = Template::generateStyleTag('bundles/contaodtvapi/progress.css');
        $GLOBALS['TL_HEAD'][] = Template::generateScriptTag('bundles/contaodtvapi/events/search.js', false, null, null, 'anonymous');
        $template->eventsearchType = $model->td_eventsearch_type;
        return $template->getResponse();
    }

    private function isUseAutoItem(): bool
    {
        return $this->framework->getAdapter(Config::class)->get('useAutoItem');
    }
}
