import { svelte } from "@sveltejs/vite-plugin-svelte";
import cssInjectedByJsPlugin from 'vite-plugin-css-injected-by-js'

export const viteBaseConfig = {
  plugins: [
        cssInjectedByJsPlugin(),
    svelte({
      emitCss: false,
      compilerOptions: {
        css: "injected",
        hydratable: true,
        dev: true
      },
    }),
  ],
  build: {
    outDir: "../src/Resources/public/events",
    emptyOutDir: true,
    manifest: false,
    rollupOptions: {
      input: {
        index: "./index.html",
        bsw: "./bsw.html",
        jmc: "./jmc.html",
        einzel: "./einzel.html",
        formation: "./formation.html",
        zuschauer: "./zuschauer.html",
      },
      output: {
        preserveModules: false,
        entryFileNames: "[name].js",
        chunkFileNames: "[name].js",
      },
    },
  },
};
