import { writable, derived } from "svelte/store";
import baseUrl from "../lib/baseUrl";
import type Verein from "../types/Verein";

export async function loadVereine() {
  const response = await fetch(baseUrl + "/vereine");
  const data = (await response.json()) as Verein[];

  vereine.set(data);

  const showSingle = location.href.match(/\/verein\/(\d+)/);
  if (showSingle) {
    const vereinId = parseInt(showSingle[1]);
    const verein = data.find((v) => v.nummer === vereinId);
    if (verein) {
      vereinFilter.set(verein.name);
    }
  } else {
    vereinFilter.set("");
  }
}

export const filteredVereineByZipcode = writable<Record<string, Verein[]>>({});
export const filteredVereine = writable<Verein[]>([]);
export const vereine = writable<Verein[]>([]);
export const vereinFilter = writable<string>(" ");
export const vereinLtv = writable<number[]>([]);
export const vereinPage = writable<number>(1);

export const combinedFilter = derived(
  [vereinFilter, vereinLtv, vereine],
  ([$vereinFilter, $vereineLtv, $vereine]) => {
    const vnumber = parseInt($vereinFilter, 10);
    const filtered = $vereine.filter((verein) => {
      // Filter nach vereinFilter (Name oder Nummer)
      const matchesFilter = !(
        $vereinFilter &&
        verein.nummer != vnumber &&
        !verein.name.toLowerCase().includes($vereinFilter.toLowerCase())
      );

      // Filter nach vereineLtv (falls LTV-Filter aktiv ist)
      const matchesLtv =
        $vereineLtv.length === 0 || $vereineLtv.includes(verein.federation);

      return matchesFilter && matchesLtv;
    });

    const byZipcode = filtered.reduce((acc, verein) => {
      if (!acc[verein.zipCode]) {
        acc[verein.zipCode] = [];
      }
      acc[verein.zipCode].push(verein);
      return acc;
    }, {} as Record<string, Verein[]>);

    vereinPage.set(0); // Reset page when filter changes

    return { filtered, byZipcode };
  }
);

// Subscription auf den kombinierten Store
combinedFilter.subscribe(({ filtered, byZipcode }) => {
  filteredVereine.set(filtered);
  filteredVereineByZipcode.set(byZipcode);
});

// Entfernen Sie die alte vereinFilter subscription
// vereinFilter.subscribe(...) - wird durch combinedFilter ersetzt
