import { writable } from "svelte/store";
import baseUrl from "../lib/baseUrl";
import type RestResult from "../types/RestResult";
import type Tags from "../types/Tags";

export async function loadParameter(filters: number[]) {
  tags.set({ loading: true });
  const response = await fetch(
    baseUrl + "/events/tags?" + filters.map((f) => "filter=" + f).join("&")
  );
  const data = (await response.json()) as Tags;

  data.tags.LANDESVERBAND = data.tags.LANDESVERBAND.sort((a, b) =>
    a.shortLabel.localeCompare(b.shortLabel)
  );
  data.tags.LEISTUNGSKLASSEN = (data.tags.LEISTUNGSKLASSEN || []).sort((a, b) =>
    prepareLeistungsklasse(a.shortLabel).localeCompare(
      prepareLeistungsklasse(b.shortLabel)
    )
  );
  tags.set({ data });
}

export const tags = writable<RestResult<Tags>>({});

function prepareLeistungsklasse(a: string) {
  return a === "S" ? "0000" : a === "" ? "xxxx" : a;
}
