import { writable } from "svelte/store";
import type FilterInput from "../types/FilterInput";
import type RestResult from "../types/RestResult";
import type Tag from "../types/Tag";
import type Tags from "../types/Tags";
// import { filterParse, filterStringify } from "./filterStringify";
import { tags } from "./TagStore";

export function loadFilter(id: string) {
  filterInput.set(
    initFilter(
      // filterParse(location.hash) ||
      JSON.parse(
        localStorage.getItem("searchfilter_" + id) || "{}"
      ) as Partial<FilterInput>
    )
  );

  filterInput.subscribe((val) => {
    localStorage.setItem("searchfilter_" + id, JSON.stringify(val));
    // location.hash = "#" + window.btoa(filterStringify(val));
  });

  tags.subscribe(validateFilters);
}

export function resetFilter() {
  filterInput.set(initFilter({}));
}

function validateTagExists(tag?: number, tags?: Tag[]) {
  return tags?.find((t) => t.id == tag) ? tag : undefined;
}

function validateFilters(tags: RestResult<Tags>) {
  if (tags.data?.tags) {
    filterInput.update((old) => ({
      ...old,
      leistungsklasse: validateTagExists(
        old.leistungsklasse,
        tags.data?.tags.LEISTUNGSKLASSEN
      ),
      turnierart: validateTagExists(
        old.turnierart,
        tags.data?.tags.TURNIERARTEN
      ),
      selectionTurnierform: old.selectionTurnierform.filter((i) =>
        tags.data?.tags.TURNIERFORMEN?.find((t) => t.id == i)
      ),
      selectionAltersklasse: old.selectionAltersklasse.filter((i) =>
        tags.data?.tags.ALTERSKLASSEN?.find((t) => t.id == i)
      ),
      selectionLtv: old.selectionLtv.filter((i) =>
        tags.data?.tags.LANDESVERBAND?.find((t) => t.id == i)
      ),
      selectionWettbewerbsart: old.selectionWettbewerbsart.filter((i) =>
        tags.data?.tags.WETTBEWERBSART?.find((t) => t.id == i)
      ),
      selectionTurnierart: old.selectionTurnierart.filter((i) =>
        tags.data?.tags.TURNIERARTEN?.find((t) => t.id == i)
      ),
    }));
  }
}

function initFilter(initialData: Partial<FilterInput>): FilterInput {
  return {
    ...initialData,
    conjunction: !!initialData.conjunction,
    allItems: initialData.allItems !== false,
    selectionTurnierform: initialData.selectionTurnierform || [],
    selectionLtv: initialData.selectionLtv || [],
    selectionAltersklasse: initialData.selectionAltersklasse || [],
    selectionTurnierart: initialData.selectionTurnierart || [],
    selectionWettbewerbsart: initialData.selectionWettbewerbsart || [],
    dateFrom: initialData.dateFrom || new Date().toISOString().substring(0, 10),
    dateTo:
      initialData.dateTo ||
      new Date(Date.now() + 180 * 24 * 3600 * 1000)
        .toISOString()
        .substring(0, 10),
  };
}

// http://127.0.0.1:5173/einzel.html#eyJjb25qdW5jdGlvbiI6ZmFsc2UsInNlbGVjdGlvblR1cm5pZXJmb3JtIjpbXSwic2VsZWN0aW9uTHR2IjpbXSwic2VsZWN0aW9uQWx0ZXJza2xhc3NlIjpbXSwic2VsZWN0aW9uVHVybmllcmFydCI6W10sInNlbGVjdGlvbldldHRiZXdlcmJzYXJ0IjpbXSwiZGF0ZUZyb20iOiIyMDIzLTAzLTI4IiwiZGF0ZVRvIjoiMjAyMy0wOS0yNCIsImFsdGVyc2tsYXNzZSI6MTEwNCwibGVpc3R1bmdza2xhc3NlIjoxMDcsInR1cm5pZXJhcnQiOjIwNiwiYWxsSXRlbXMiOnRydWV9

export const filterInput = writable<FilterInput>(initFilter({}));
