import * as linkify from "linkifyjs";

export function getDescriptionWithLinks(text: string) {
  const html = text
    .replace(/</g, "&lt;")
    .replace(/>/g, "&gt;")
    .replace(/\*\*(.*?)\*\*/g, "<b>$1</b>");
  return linkify
    .tokenize(html)
    .map((v) =>
      v.t == "nl"
        ? "\n"
        : v.t == "url"
        ? `<a href="${v.toHref()}" target="_blank">${v.v}</a>`
        : v.t == "email"
        ? `<a href="mailto:${v.v}">${v.v}</a>`
        : v.t == "phone"
        ? `<a href="tel:${v.v.replace(/[\s\+\/\-]/g, "")}">${v.v}</a>`
        : v.v
    )
    .join("");
}
