export function formatDate(date: string | number) {
  if (!date) return "";

  const d = new Date(date);

  return f2(d.getDate()) + "." + f2(d.getMonth() + 1) + "." + d.getFullYear();
}

export function formatWeekday(date: string | number) {
  if (!date) return "";

  const d = new Date(date);

  return [
    "Sonntag",
    "Montag",
    "Dienstag",
    "Mittwoch",
    "Donnerstag",
    "Freitag",
    "Samstag",
  ][d.getDay()];
}

export function formatTime(date: string | number) {
  if (!date) return "";

  const d = new Date(date);

  return d.getHours() + ":" + f2(d.getMinutes());
}

export function formatDateSpan(date1: string | number, date2: string | number) {
  const d1 = formatDate(date1);
  const d2 = formatDate(date2);
  const sep = "-";

  if (d1 == d2) return d1;
  else if (d1.substring(3) == d2.substring(3)) {
    return d1.substring(0, 3) + sep + d2;
  } else if (d1.substring(6) == d2.substring(6)) {
    return d1.substring(0, 6) + sep + d2;
  } else return d1 + sep + d2;
}

function f2(x: number) {
  return (x > 9 ? "" : "0") + x;
}
