export function accordion(node: HTMLElement, isOpen: boolean) {
  node.style.height = isOpen ? "auto" : "0";
  node.style.overflow = "hidden";
  if (!isOpen) node.style.visibility = "hidden";
  node.style.transition = "height 0.25s ease-in-out";
  return {
    update(isOpen: boolean) {
      if (isOpen) {
        node.style.visibility = "visible";
        // Temporarily set to auto to measure the actual height
        node.style.height = "auto";
        const fullHeight = node.scrollHeight;
        node.style.height = "0";
        // Force reflow
        node.offsetHeight;
        node.style.height = fullHeight + "px";
      } else {
        node.style.height = "0";
        setTimeout(() => (node.style.visibility = "hidden"), 250);
      }
    },
  };
}
