import SearchBsw from "./pages/SearchBsw.svelte";
import SearchEinzel from "./pages/SearchEinzel.svelte";
import SearchFormation from "./pages/SearchFormation.svelte";
import SearchJmc from "./pages/SearchJmc.svelte";
import SearchZuschauer from "./pages/SearchZuschauer.svelte";
import SearchVereine from "./pages/SearchVereine.svelte";
import SearchLehrgang from "./pages/SearchLehrgang.svelte";
import { hydrate } from "svelte";

function mountComponent() {
  const target = document.getElementById("mount-search");
  if (target) {
    const type = target.getAttribute("data-type");

    switch (type) {
      case "BSW":
        hydrate(SearchBsw, {
          target,
        });
        break;
      case "JMC":
        hydrate(SearchJmc, {
          target,
        });
        break;
      case "Formation":
        hydrate(SearchFormation, {
          target,
        });
        break;
      case "Zuschauer":
        hydrate(SearchZuschauer, {
          target,
        });
        break;
      case "Vereine":
        hydrate(SearchVereine, {
          target,
        });
        break;
      case "Lehrgang":
        hydrate(SearchLehrgang, {
          target,
        });
        break;
      default:
        hydrate(SearchEinzel, {
          target,
        });
        break;
    }
    return true;
  }
}

if (!mountComponent()) {
  const observer = new MutationObserver(() => {
    if (mountComponent()) observer.disconnect();
  });

  observer.observe(document, {
    attributes: false,
    childList: true,
    characterData: false,
    subtree: true,
  });
}
