<?php

namespace Tanzsport\ContaoAdsmanBundle;

class ModuleAdsmanBanner extends \Module
{

    protected $strTemplate = 'mod_adsman_banner';

    public function generate()
    {
        if (TL_MODE == 'BE') {
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### ' . $GLOBALS['TL_LANG']['FMD']['adsman_banner'][0] . ' ###';
            $objTemplate->title = $this->headline;
            $objTemplate->id = $this->id;
            $objTemplate->link = $this->name;
            $objTemplate->href = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        return parent::generate();
    }

    protected function compile()
    {
        $strMode = 'iframe';
        if ($this->adsman_mode) {
            $strMode = $this->adsman_mode;
        }
        $strUrl = trim(\Config::get('adsman_url'));
        if (!$strUrl) {
            $strUrl = 'https://werbung.tanzsport.de/adsman';
        } else {
            if (strrpos($strUrl, '/') == strlen($strUrl) - 1) {
                $strUrl = substr($strUrl, 0, strlen($strUrl) - 1);
            }
        }
        $objTemplate = new \FrontendTemplate("adsman_{$strMode}");
        $objTemplate->bannerId = intval($this->adsman_banner);
        $objTemplate->campainId = intval($this->adsman_campain);
        $objTemplate->width = intval($this->adsman_width);
        $objTemplate->height = intval($this->adsman_height);
        $objTemplate->url = $strUrl;

        $this->Template->banner = $objTemplate->parse();
    }

}
