<?php

namespace Tanzsport\API\Turnier\Resource;

use Tanzsport\API\AbstractAPITestCase;

class EinzelwettbewerbResourceTest extends AbstractAPITestCase
{

	/**
	 * @var EinzelwettbewerbResource
	 */
	private $r;

	public function setUp(): void
	{
		parent::setUp();
		$this->r = new EinzelwettbewerbResource($this->getEndpoint());
	}

	public function testGetAlleParameter()
	{
		$this->assertNotNull($this->r->getAlleParameter());
	}

	public function testGetRegeln()
	{
		$regeln = $this->r->getRegeln();
		$this->assertNotNull($regeln);
		$this->assertTrue(is_array($regeln));
		$this->assertTrue(!empty($regeln));
	}

	public function testGetStartgruppen()
	{
		$startgruppen = $this->r->getStartgruppen();
		$this->assertNotNull($startgruppen);
		$this->assertTrue(is_array($startgruppen));
		$this->assertTrue(!empty($startgruppen));
	}

	public function testGetStarklassen()
	{
		$startklassen = $this->r->getStartklassen('Hgr');
		$this->assertNotNull($startklassen);
		$this->assertTrue(is_array($startklassen));
		$this->assertTrue(!empty($startklassen));
	}

	public function testGetTurnierarten()
	{
		$turnierarten = $this->r->getTurnierarten('Hgr', 'A');
		$this->assertNotNull($turnierarten);
		$this->assertTrue(is_array($turnierarten));
		$this->assertTrue(!empty($turnierarten));
	}

	public function testFindJson()
	{
		$veranstaltungen = $this->r->findJson('01.01.2014', '31.12.2014', null, null, 'OT', 'Berlin', 'HGR', 'A', 'ST', 'HGR II', 'A', 'ST', true, 1, 5);
		$this->assertNotNull($veranstaltungen);
	}

	public function testFindPdf()
	{
		$response = $this->r->findPdf('01.01.2014', '31.12.2014', null, null, 'OT', 'Berlin', 'HGR', 'A', 'ST', 'HGR II', 'A', 'ST', false, 0, 5);
		$this->assertNotNull($response);
		$this->assertStringContainsString('application/pdf', $response->getHeader('Content-Type')[0]);
	}
}
