<?php
namespace Tanzsport\API\Turnier;

use Tanzsport\API\AbstractAPITestCase;

class JmdWettbewerbDatenbankServiceTest extends AbstractAPITestCase
{

	/**
	 * @var JmdWettbewerbDatenbankService
	 */
	private $service;

	public function setUp(): void
	{
		parent::setUp();
		$this->service = new JmdWettbewerbDatenbankService($this->getEndpoint(), false, null);
	}

	public function testGetLandesverbaende()
	{
		$landesverbaende = $this->service->getLandesverbaende();
		$this->assertNotNull($landesverbaende);
		$this->assertTrue(is_array($landesverbaende));
		$this->assertNotEmpty($landesverbaende);
	}

	public function testGetTypen()
	{
		$typen = $this->service->getTypen();
		$this->assertNotNull($typen);
		$this->assertTrue(is_array($typen));
		$this->assertNotEmpty($typen);
		$this->assertTrue(isset($typen['JMD']));
	}

	public function testGetWettbewerbsarten()
	{
		$wettbewerbsarten = $this->service->getWettbewerbsarten();
		$this->assertNotNull($wettbewerbsarten);
		$this->assertTrue(is_array($wettbewerbsarten));
		$this->assertNotEmpty($wettbewerbsarten);
		$this->assertTrue(isset($wettbewerbsarten['SG']));
	}

	public function testSuchen()
	{
		$s = new JmdWettbewerbSuche();

		$s
			->setVon('01.01.2014')
			->setBis('31.12.2014')
			->setPlzVon('10000')
			->setPlzBis('20000')
			->addLandesverband('TNW')
			->addTyp('JMD')
			->addWettbewerbsart('F');

		$e = $this->service->suchen($s);
		$this->assertNotNull($e);

		$b = $this->service->exportieren($s);
		$this->assertNotNull($b);
	}

	public function testSerializeUnserialize()
	{
		$val = array(1, 2, 3);
		$serialized = $this->service->serialize($val);
		$this->assertEquals($val, $this->service->unserialize($serialized));
	}

	public function testSuchen_FailedValidation()
	{
		$this->expectException(\InvalidArgumentException::class);
		$this->expectExceptionMessage('Suchparameter sind ungültig');
		$s = new JmdWettbewerbSuche();
		$this->service->suchen($s);
	}

	public function testCreateDefault()
	{
		$s = $this->service->createDefaultSuche();
		$this->assertNotNull($s);
		$this->assertTrue($s instanceof JmdWettbewerbSuche);
		$br = $this->service->validate($s);
		$this->assertFalse($br->isError());
	}

	public function testWithPersistenceHandler()
	{
		$service = new JmdWettbewerbDatenbankService($this->getEndpoint(), false, null, 'XXX', 365);
		$suche = $service->createDefaultSuche();
		$this->assertNotNull($suche);

		$suche->addWettbewerbsart('SG');
		$suche->setSeite(1);
		$suche->setAnzahl(1);
		$service->suchen($suche);

		$suche = $service->createDefaultSuche();

		$this->assertTrue(in_array('SG', $suche->getWettbewerbsarten()));
	}
}
