<?php
namespace Tanzsport\API\Turnier;

use Tanzsport\API\AbstractAPITestCase;

class FormationswettbewerbDatenbankServiceTest extends AbstractAPITestCase
{

	/**
	 * @var FormationswettbewerbDatenbankService
	 */
	private $service;

	public function setUp(): void
	{
		parent::setUp();
		$this->service = new FormationswettbewerbDatenbankService($this->getEndpoint(), false, null);
	}

	public function testGetLandesverbaende()
	{
		$landesverbaende = $this->service->getLandesverbaende();
		$this->assertNotNull($landesverbaende);
		$this->assertTrue(is_array($landesverbaende));
		$this->assertNotEmpty($landesverbaende);
	}

	public function testGetLigen()
	{
		$ligen = $this->service->getLigen();
		$this->assertNotNull($ligen);
		$this->assertTrue(is_array($ligen));
		$this->assertNotEmpty($ligen);
		$this->assertTrue(in_array('Regionalliga', $ligen));
	}

	public function testGetTurnierarten()
	{
		$turnierarten = $this->service->getTurnierarten('Regionalliga');
		$this->assertNotNull($turnierarten);
		$this->assertTrue(is_array($turnierarten));
		$this->assertNotEmpty($turnierarten);
		$this->assertTrue(in_array('Latein', $turnierarten));

		$turnierarten = $this->service->getTurnierarten('Regionalliga');
		$this->assertNotNull($turnierarten);
		$this->assertTrue(is_array($turnierarten));
		$this->assertNotEmpty($turnierarten);
		$this->assertTrue(in_array('Latein', $turnierarten));
	}

	public function testSuchen()
	{
		$s = new FormationswettbewerbSuche();

		$s
			->setVon('01.01.2014')
			->setBis('31.12.2014')
			->setPlzVon('10000')
			->setPlzBis('20000')
			->addLandesverband('TNW')
			->setLiga('Regionalliga')
			->setTurnierart('Latein');

		$e = $this->service->suchen($s);
		$this->assertNotNull($e);

		$b = $this->service->exportieren($s);
		$this->assertNotNull($b);
	}

	public function testSerializeUnserialize()
	{
		$val = array(1, 2, 3);
		$serialized = $this->service->serialize($val);
		$this->assertEquals($val, $this->service->unserialize($serialized));
	}

	public function testSuchen_FailedValidation()
	{
		$this->expectException(\InvalidArgumentException::class);
		$this->expectExceptionMessage('Suchparameter sind ungültig');
		$s = new FormationswettbewerbSuche();
		$this->service->suchen($s);
	}

	public function testCreateDefault()
	{
		$s = $this->service->createDefaultSuche();
		$this->assertNotNull($s);
		$this->assertTrue($s instanceof FormationswettbewerbSuche);
		$br = $this->service->validate($s);
		$this->assertFalse($br->isError());
	}

	public function testWithPersistenceHandler()
	{
		$service = new FormationswettbewerbDatenbankService($this->getEndpoint(), false, null, 'XXX', 365);
		$suche = $service->createDefaultSuche();
		$this->assertNotNull($suche);

		$suche->setLiga('Regionalliga');
		$suche->setSeite(1);
		$suche->setAnzahl(1);
		$service->suchen($suche);

		$suche = $service->createDefaultSuche();

		$this->assertEquals('Regionalliga', $suche->getLiga());
	}
}
