<?php
namespace Tanzsport\API\Turnier;

use Tanzsport\API\AbstractAPITestCase;

class EinzelwettbewerbDatenbankServiceTest extends AbstractAPITestCase
{

	/**
	 * @var EinzelwettbewerbDatenbankService
	 */
	private $service;

	public function setUp(): void
	{
		parent::setUp();
		$this->service = new EinzelwettbewerbDatenbankService($this->getEndpoint(), false, null);
	}

	public function testGetLandesverbaende()
	{
		$landesverbaende = $this->service->getLandesverbaende();
		$this->assertNotNull($landesverbaende);
		$this->assertTrue(is_array($landesverbaende));
		$this->assertNotEmpty($landesverbaende);
	}

	public function testGetStartgruppen()
	{
		$startgruppen = $this->service->getStartgruppen();
		$this->assertNotNull($startgruppen);
		$this->assertTrue(is_array($startgruppen));
		$this->assertNotEmpty($startgruppen);
	}

	public function testGetStartklassen()
	{
		$startklassen = $this->service->getStartklassen('Hgr');
		$this->assertNotNull($startklassen);
		$this->assertTrue(is_array($startklassen));
		$this->assertNotEmpty($startklassen);

		$startklassen = $this->service->getStartklassen('Hgr');
		$this->assertNotNull($startklassen);
		$this->assertTrue(is_array($startklassen));
		$this->assertNotEmpty($startklassen);
	}

	public function testGetTurnierarten()
	{
		$turnierarten = $this->service->getTurnierarten('Hgr', 'A');
		$this->assertNotNull($turnierarten);
		$this->assertTrue(is_array($turnierarten));
		$this->assertNotEmpty($turnierarten);

		$turnierarten = $this->service->getTurnierarten('Hgr', 'A');
		$this->assertNotNull($turnierarten);
		$this->assertTrue(is_array($turnierarten));
		$this->assertNotEmpty($turnierarten);
	}

	public function testGetTypen()
	{
		$typen = $this->service->getTypen();
		$this->assertNotNull($typen);
		$this->assertTrue(is_array($typen));
		$this->assertNotEmpty($typen);
	}

	public function testSuchen()
	{
		$s = new EinzelwettbewerbSuche();

		$s
			->setVon('01.01.2014')
			->setBis('31.12.2014')
			->setPlzVon('10000')
			->setPlzBis('20000')
			->addTyp('OT')
			->addLandesverband('Berlin')
			->setTurnier1('HGR', 'A', 'ST')
			->setTurnier2('HGR II', 'A', 'ST')
			->setKonjunktion(true);

		$e = $this->service->suchen($s);
		$this->assertNotNull($e);

		$b = $this->service->exportieren($s);
		$this->assertNotNull($b);
	}

	public function testSerializeUnserialize()
	{
		$val = array(1, 2, 3);
		$serialized = $this->service->serialize($val);
		$this->assertEquals($val, $this->service->unserialize($serialized));
	}

	public function testSuchen_FailedValidation()
	{
		$this->expectException(\InvalidArgumentException::class);
		$this->expectExceptionMessage('Suchparameter sind ungültig');
		$s = new EinzelwettbewerbSuche();
		$this->service->suchen($s);
	}

	public function testCreateDefault()
	{
		$s = $this->service->createDefaultSuche();
		$this->assertNotNull($s);
		$br = $this->service->validate($s);
		$this->assertFalse($br->isError());
	}

	public function testWithPersistenceHandler()
	{
		$service = new EinzelwettbewerbDatenbankService($this->getEndpoint(), false, null, 'XXX', 365);
		$suche = $service->createDefaultSuche();
		$this->assertNotNull($suche);

		$suche->setTurnier1('HGR', 'A', 'LAT');
		$suche->setSeite(1);
		$suche->setAnzahl(1);
		$service->suchen($suche);

		$suche = $service->createDefaultSuche();

		$this->assertEquals('HGR', $suche->getTurnier1()->gruppe);
		$this->assertEquals('A', $suche->getTurnier1()->klasse);
		$this->assertEquals('LAT', $suche->getTurnier1()->turnierart);
	}
}
