<?php
namespace Tanzsport\API\Lehrgang;

use PHPUnit\Framework\TestCase;

class LehrgangTest extends TestCase
{

	public function testModel()
	{
		$data = (object)array('datum' => '2012-02-03T23:00:00.000+0000', 'prop' => 'value', 'typ' => 'ERWERB');
		$l = new Lehrgang($data);
		$this->assertEquals('04.02.2012', $l->datum->format('d.m.Y'));
		$this->assertTrue(isset($l->datum));
		$this->assertTrue(isset($l->prop));
		$this->assertEquals('value', $l->prop);
		$this->assertFalse(isset($l->unknown_property));
		$this->assertTrue($l->isErwerb());
		$this->assertNull($l->unknown_property);
	}
} 
