<?php

namespace Tanzsport\Util;

class Serializer
{

	private static $cipher = 'aes-256-cbc';

	/**
	 * @var string
	 */
	private $key;

	private $iv;

	public function __construct($key)
	{
		$this->key = $key;
		$this->iv = base64_decode('WpEubUSsAHlIV7kFokB4CA==');
	}

	/**
	 * @param $value
	 * @return string
	 * @throws \InvalidArgumentException
	 */
	public function serializeAndEncrypt($value)
	{
		// @codeCoverageIgnoreStart
		if ($value == null) {
			throw new \InvalidArgumentException("Wert erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$serialized = serialize($value);
		$encrypted = null;
		if ($this->key) {
			$encrypted = $this->encrypt($this->key, $serialized);
		}

		return $encrypted ? base64_encode($encrypted) : base64_encode($serialized);
	}

	/**
	 * @param $input
	 * @return mixed
	 * @throws \InvalidArgumentException
	 */
	public function decryptAndDeserialize($input)
	{
		// @codeCoverageIgnoreStart
		if ($input == null) {
			throw new \InvalidArgumentException("Input erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$decrypted = null;
		if ($this->key) {
			$decrypted = $this->decrypt($this->key, base64_decode($input));
		} else {
			$decrypted = base64_decode($input);
		}

		return $decrypted ? unserialize($decrypted) : null;
	}

	private function decrypt($key, $str)
	{
		return @openssl_decrypt($str, self::$cipher, $key, OPENSSL_RAW_DATA | OPENSSL_ZERO_PADDING, $this->iv);
	}

	private function encrypt($key, $str)
	{
		if (($l = (strlen($str) & 15)) > 0) {
			$str .= str_repeat(chr(0), 16 - $l);
		}
		return @openssl_encrypt($str, self::$cipher, $key, OPENSSL_RAW_DATA | OPENSSL_ZERO_PADDING, $this->iv);
	}

}
