<?php
namespace Tanzsport\API\Turnier;

/**
 * Class Veranstaltung
 * @package Tanzsport\API\Turnier
 */
class Veranstaltung
{

	/**
	 * @var \stdClass
	 */
	private $v;

	/**
	 * @var \DateTime
	 */
	private $datum;

	/**
	 * @var Turnier[]
	 */
	private $turniere;

	public function __construct(\stdClass $v)
	{
		// @codeCoverageIgnoreStart
		if ($v == null) {
			throw new \InvalidArgumentException("Daten erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$this->v = $v;

		$this->datum = \DateTime::createFromFormat('Y-m-d\TH:i:s.\0\0\0O', $this->v->datum)
			->setTimezone(new \DateTimeZone('Europe/Berlin'));

		$this->turniere = array();
		foreach ($this->v->turniere as $turnier) {
			$this->turniere[] = new Turnier((object)$turnier);
		}
	}

	public function __get($key)
	{
		switch ($key) {
			case 'datum':
				return $this->datum;
			case 'turniere':
				return $this->turniere;
			default;
				return $this->v->$key;
		}
	}

	public function __isset($key)
	{
		return isset($this->v->$key);
	}

}
