<?php
namespace Tanzsport\API\Turnier;

/**
 * Class Turnier
 * @package Tanzsport\API\Turnier
 *
 * @property string $startgruppe
 * @property string $startklasse
 * @property string $turnierart
 */
class Turnier
{

	/**
	 * @var \stdClass
	 */
	private $turnier;

	public function __construct(\stdClass $turnier)
	{
		// @codeCoverageIgnoreStart
		if ($turnier == null) {
			throw new \InvalidArgumentException("Daten erforderlich!");
		}
		// @codeCoverageIgnoreEnd
		$this->turnier = $turnier;
	}

	public function __get($key)
	{
		return $this->turnier->$key;
	}

	public function __isset($key)
	{
		return isset($this->turnier->$key);
	}

	public function matches(AbstractSuche $suche)
	{
		if ($suche instanceof EinzelwettbewerbSuche) {
			return $this->matchesEinzel($suche);
		} elseif ($suche instanceof FormationswettbewerbSuche) {
			return $this->matchesFormation($suche);
		} elseif ($suche instanceof JmdWettbewerbSuche) {
			return $this->matchesJmd($suche);
			// @codeCoverageIgnoreStart
		} else {
			return false;
		}
		// @codeCoverageIgnoreEnd
	}

	private function matchesEinzel(EinzelwettbewerbSuche $suche)
	{
		return $this->matchesValues($suche->getTurnier1()->gruppe, $suche->getTurnier1()->klasse, $suche->getTurnier1()->turnierart)
		|| $this->matchesValues($suche->getTurnier2()->gruppe, $suche->getTurnier2()->klasse, $suche->getTurnier2()->turnierart);
	}

	private function matchesFormation(FormationswettbewerbSuche $suche)
	{
		if ($suche->getLiga() != null) {
			if ($suche->getTurnierart() != null) {
				return stripos($this->bemerkung, $suche->getLiga()) !== false && stripos($this->bemerkung, $suche->getTurnierart()) !== false;
			} else {
				return stripos($this->bemerkung, $suche->getLiga()) !== false;
			}
		} else {
			return false;
		}
	}

	private function matchesJmd(JmdWettbewerbSuche $suche)
	{
		if ($suche->getWettbewerbsarten() != null) {
			$matches = false;
			foreach ($suche->getWettbewerbsarten() as $w) {
				switch ($w) {
					case 'F':
						if (stripos($this->bemerkung, 'liga') !== false) {
							$matches = true;
						}
					case 'SG':
						if (stripos($this->bemerkung, 'small group') !== false) {
							$matches = true;
						}
					case 'S':
						if (stripos($this->bemerkung, 'solo') !== false) {
							$matches = true;
						}
					case 'D':
						if (stripos($this->bemerkung, 'duo') !== false) {
							$matches = true;
						}
				}
			}
			return $matches;
		} else {
			return false;
		}
	}

	private function matchesValues($startgruppe, $startklasse, $turnierart)
	{
		if ($startgruppe != null) {
			if ($startklasse != null) {
				if ($turnierart != null) {
					return $this->strMatches($this->startgruppe, $startgruppe)
					&& $this->strMatches($this->startklasse, $startklasse)
					&& $this->strMatches($this->turnierart, $turnierart);
				} else {
					return $this->strMatches($this->startgruppe, $startgruppe)
					&& $this->strMatches($this->startklasse, $startklasse);
				}
			} else {
				return $this->strMatches($this->startgruppe, $startgruppe);
			}
		}
	}

	private function strMatches($a, $b)
	{
		return strcasecmp(trim($a), trim($b)) == 0;
	}
}