<?php
declare(strict_types=1);

namespace Tanzsport\API\Turnier\Resource;

use Psr\Http\Message\ResponseInterface;

class FormationswettbewerbResource extends AbstractWettbewerbResource
{

	public function getAlleParameter()
	{
		return $this->getJson('1/tdb/veranstaltungen/formation/parameter');
	}

	public function getRegeln()
	{
		return $this->getJson('1/tdb/veranstaltungen/formation/parameter/regeln');
	}

	public function getLigen()
	{
		return $this->getJson('1/tdb/veranstaltungen/formation/parameter/ligen');
	}

	public function getTurnierarten($liga)
	{
		// @codeCoverageIgnoreStart
		if ($liga == null) {
			throw new \InvalidArgumentException("Liga erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		return $this->getJson('1/tdb/veranstaltungen/formation/parameter/turnierarten', ['query' => ['l' => $liga]]);
	}

	public function findJson(
		$von, $bis, $plzVon = null, $plzBis = null, $landesverbaende = null,
		$liga = null, $turnierart = null, $seite = 0, $anzahl = 10
	)
	{
		return $this->parseJson($this->findInternal($von, $bis, $plzVon, $plzBis, $landesverbaende, $liga, $turnierart,
			$seite, $anzahl, 'application/json'));
	}

	public function findPdf(
		$von, $bis, $plzVon = null, $plzBis = null, $landesverbaende = null,
		$liga = null, $turnierart = null
	): ResponseInterface
	{
		return $this->findInternal($von, $bis, $plzVon, $plzBis, $landesverbaende, $liga, $turnierart, null, null,
			'application/pdf');
	}

	private function findInternal(
		$von, $bis, $plzVon = null, $plzBis = null, $landesverbaende = null,
		$liga = null, $turnierart = null, $seite = 0, $anzahl = 10, $accept = 'application/json'
	): ResponseInterface
	{
		// @codeCoverageIgnoreStart
		if ($von == null) {
			throw new \InvalidArgumentException("Datum von erforderlich!");
		}
		if ($bis == null) {
			throw new \InvalidArgumentException("Datum bis erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$headers = $accept ? ['Accept' => $accept] : [];
		$query = [
			'von' => $von,
			'bis' => $bis
		];
		if ($plzVon != null) {
			$query['plzVon'] = $plzVon;
		}
		if ($plzBis != null) {
			$query['plzBis'] = $plzBis;
		}
		if ($landesverbaende != null) {
			$query['l'] = $landesverbaende;
		}
		if ($liga != null) {
			$query['t1l'] = $liga;
			if ($turnierart != null) {
				$query['t1a'] = $turnierart;
			}
		}
		if ($seite != null) {
			$query['seite'] = $seite;
		}
		if ($anzahl != null) {
			$query['anzah'] = $anzahl;
		}

		return $this->get('1/tdb/veranstaltungen/formation', ['headers' => $headers, 'query' => $query]);
	}

}
