<?php
declare(strict_types=1);

namespace Tanzsport\API\Turnier;

class JmdWettbewerbSuche extends AbstractSuche implements TurnierSuche
{

	/**
	 * @var Array<string>
	 */
	private array $typen;
	/**
	 * @var Array<string>
	 */
	private array $wettbewerbsarten;

	public function __construct()
	{
		parent::__construct();
		$this->typen = [];
		$this->wettbewerbsarten = [];
	}

	/**
	 * @return Array<string>
	 */
	public function getTypen(): array
	{
		return $this->typen;
	}

	public function addTyp(?string $typ): self
	{
		if (!in_array($typ, $this->typen)) {
			$this->typen[] = $typ;
		}
		return $this;
	}

	/**
	 * @return Array<string>
	 */
	public function getWettbewerbsarten(): array
	{
		return $this->wettbewerbsarten;
	}

	public function addWettbewerbsart(?string $wettbewerbsart): self
	{
		if (!in_array($wettbewerbsart, $this->wettbewerbsarten)) {
			$this->wettbewerbsarten[] = $wettbewerbsart;
		}
		return $this;
	}
}
