<?php
declare(strict_types=1);

namespace Tanzsport\API\Turnier;

class EinzelwettbewerbSuche extends AbstractSuche implements TurnierSuche
{

	/**
	 * @var Array<string>
	 */
	private array $typen;
	private EinzelwettbewerbSucheTurnier $turnier1;
	private EinzelwettbewerbSucheTurnier $turnier2;
	private ?string $konjunktion = null;

	public function __construct()
	{
		parent::__construct();
		$this->typen = [];
		$this->turnier1 = new EinzelwettbewerbSucheTurnier();
		$this->turnier2 = new EinzelwettbewerbSucheTurnier();
	}

	/**
	 * @return Array<string>
	 */
	public function getTypen(): array
	{
		return $this->typen;
	}

	public function addTyp(?string $typ): self
	{
		if ($typ != null && !in_array($typ, $this->typen)) {
			$this->typen[] = $typ;
		}
		return $this;
	}

	public function getTurnier1(): EinzelwettbewerbSucheTurnier
	{
		return $this->turnier1;
	}

	public function setTurnier1(?string $gruppe, ?string $klasse, ?string $turnierart): self
	{
		$this->turnier1->gruppe = $gruppe;
		$this->turnier1->klasse = $klasse;
		$this->turnier1->turnierart = $turnierart;
		return $this;
	}

	public function getTurnier2(): EinzelwettbewerbSucheTurnier
	{
		return $this->turnier2;
	}

	public function setTurnier2(?string $gruppe, ?string $klasse, ?string $turnierart): self
	{
		$this->turnier2->gruppe = $gruppe;
		$this->turnier2->klasse = $klasse;
		$this->turnier2->turnierart = $turnierart;
		return $this;
	}

	public function getKonjunktion(): ?string
	{
		return $this->konjunktion;
	}

	public function setKonjunktion(?string $konjunktion): self
	{
		$this->konjunktion = $konjunktion;
		return $this;
	}
}
