<?php
namespace Tanzsport\API\Lehrgang\Validation;

use Tanzsport\Validation\BindingResult;
use Tanzsport\Validation\Validator;

class LehrgangSucheValidator implements Validator
{

	const REGEX_DATUM1 = '/(\d{1,2})\.(\d{1,2})\.(\d{4})/';
	const REGEX_DATUM2 = '/(\d{4})\-(\d{1,2})\-(\d{1,2})/';
	const REGEX_DATUM3 = '/(\d{4})\/(\d{1,2})\/(\d{1,2})/';
	const CLASS_NAME = 'Tanzsport\API\Lehrgang\LehrgangSuche';

	/**
	 * @param $object
	 * @return BindingResult
	 */
	public function validate($object)
	{
		// @codeCoverageIgnoreStart
		if ($object == null) {
			throw new \InvalidArgumentException("Objekt erforderlich!");
		}
		if (get_class($object) != self::CLASS_NAME) {
			throw new \InvalidArgumentException("Zu validierendes Objekt muss vom Typ " . self::CLASS_NAME . " sein!");
		}
		// @codeCoverageIgnoreEnd

		$bindingResult = new BindingResult($object);

		$formatVon = null;
		$formatBis = null;

		if ($object->getVon() == null) {
			$bindingResult->addError('von', 'Anfangsdatum erforderlich.');
		} else {
			if (preg_match(self::REGEX_DATUM1, $object->getVon())) {
				$formatVon = 1;
			} elseif (preg_match(self::REGEX_DATUM2, $object->getVon())) {
				$formatVon = 2;
			} elseif (preg_match(self::REGEX_DATUM3, $object->getVon())) {
				$formatVon = 3;
			} else {
				$bindingResult->addError('von', 'Falsches Datumsformat für Anfangsdatum.');
			}
		}

		if ($object->getBis() == null) {
			$bindingResult->addError('bis', 'Enddatum erforderlich.');
		} else {
			if (preg_match(self::REGEX_DATUM1, $object->getBis())) {
				$formatBis = 1;
			} elseif (preg_match(self::REGEX_DATUM2, $object->getBis())) {
				$formatBis = 2;
			} elseif (preg_match(self::REGEX_DATUM3, $object->getBis())) {
				$formatBis = 3;
			} else {
				$bindingResult->addError('bis', 'Falsches Datumsformat für Enddatum.');
			}
		}

		if (!$bindingResult->hasErrors('von') && !$bindingResult->hasErrors('bis')) {
			switch($formatVon) {
				case 3:
					$dtVon = \DateTime::createFromFormat('Y/m/d', $object->getVon());
					break;
				case 2:
					$dtVon = \DateTime::createFromFormat('Y-m-d', $object->getVon());
					break;
				case 1:
				default:
					$dtVon = \DateTime::createFromFormat('d.m.Y', $object->getVon());
					break;
			}
			switch($formatBis) {
				case 3:
					$dtBis = \DateTime::createFromFormat('Y/m/d', $object->getBis());
					break;
				case 2:
					$dtBis = \DateTime::createFromFormat('Y-m-d', $object->getBis());
					break;
				case 1:
				default:
					$dtBis = \DateTime::createFromFormat('d.m.Y', $object->getBis());
					break;
			}

			if ($dtVon->diff($dtBis)->invert == 1) {
				$bindingResult->addError('bis', 'Enddatum darf nicht vor Anfangsdatum liegen.');
			}
		}

		return $bindingResult;
	}
}